/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucm.idcws.client.utils;

import java.io.PrintWriter;
import oracle.ucm.idcws.generic.obj.Container;
import oracle.ucm.idcws.generic.obj.Field;
import oracle.ucm.idcws.generic.obj.File;
import oracle.ucm.idcws.generic.obj.Generic;
import oracle.ucm.idcws.generic.obj.ResultSet;
import oracle.ucm.idcws.generic.obj.Row;
import oracle.ucm.idcws.generic.obj.Service;

public class LogUtils {
    public static final String INDENT = "  ";
    public static final String NEWLINE = "\n";
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String HTML_INDENT = "&nbsp;&nbsp;";
    public static final String HTML_NEWLINE = "<br/>";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    private String m_indent;
    private String m_newLine;
    private String m_lessThan;
    private String m_greaterThan;
    private PrintWriter m_out;
    private LogFormat m_format;
    private boolean m_closeWriter = true;

    public LogUtils() {
        this(new PrintWriter(System.out, true), false);
    }

    public LogUtils(PrintWriter out) {
        this(out, LogFormat.console, true);
    }

    public LogUtils(PrintWriter out, boolean closeWriter) {
        this(out, LogFormat.console, closeWriter);
    }

    public LogUtils(PrintWriter out, LogFormat format, boolean closeWriter) {
        this.m_out = out;
        this.m_format = format;
        this.setCloseWriter(closeWriter);
        if (format.equals((Object)LogFormat.console)) {
            this.m_indent = INDENT;
            this.m_newLine = NEWLINE;
            this.m_lessThan = LT;
            this.m_greaterThan = GT;
        } else if (format.equals((Object)LogFormat.html)) {
            this.m_indent = HTML_INDENT;
            this.m_newLine = HTML_NEWLINE;
            this.m_lessThan = HTML_LT;
            this.m_greaterThan = HTML_GT;
        }
    }

    public void logGeneric(Generic g, String prefix) {
        if (g == null) {
            this.log(prefix + "** Generic is NULL");
            return;
        }
        this.log(prefix + "WebKey: " + g.getWebKey());
        this.logService(g.getService(), prefix);
    }

    public void logService(Service s, String prefix) {
        if (s == null) {
            this.log(prefix + "** Service is NULL");
            return;
        }
        this.log(prefix + "IdcService: " + s.getIdcService());
        this.logContainer(s.getUser(), prefix);
        this.logDocument(s.getDocument(), prefix);
    }

    public void logContainer(Container c, String prefix) {
        if (c == null) {
            return;
        }
        this.log(prefix + "Container:");
        this.log(prefix + this.m_lessThan + "data" + this.m_greaterThan);
        for (Field field : c.getField()) {
            this.logField(field, prefix + this.m_indent);
        }
        this.log(prefix + this.m_lessThan + "/data" + this.m_greaterThan);
        for (ResultSet rs : c.getResultSet()) {
            this.log(prefix + this.m_lessThan + "resultset name='" + rs.getName() + "'" + this.m_greaterThan);
            this.logResultSet(rs, prefix + this.m_indent);
            this.log(prefix + this.m_lessThan + "/resultset" + this.m_greaterThan);
        }
    }

    public void logDocument(Service.Document d, String prefix) {
        if (d == null) {
            this.log(prefix + "** Document is NULL");
            return;
        }
        this.log(prefix + "Document:");
        this.log(prefix + this.m_lessThan + "localdata" + this.m_greaterThan);
        for (Field field : d.getField()) {
            this.logField(field, prefix + this.m_indent);
        }
        this.log(prefix + this.m_lessThan + "/localdata" + this.m_greaterThan);
        for (ResultSet rs : d.getResultSet()) {
            this.log(prefix + this.m_lessThan + "resultset name='" + rs.getName() + "'" + this.m_greaterThan);
            this.logResultSet(rs, prefix + this.m_indent);
            this.log(prefix + this.m_lessThan + "/resultset" + this.m_greaterThan);
        }
        for (File f : d.getFile()) {
            this.log(prefix + this.m_lessThan + "file name='" + f.getName() + "' href='" + f.getHref() + "'" + this.m_greaterThan);
            this.log(prefix + this.m_lessThan + "/file" + this.m_greaterThan);
        }
    }

    public void logField(Field f, String prefix) {
        if (f == null) {
            this.log(prefix + "** Field is NULL");
            return;
        }
        this.log(prefix + f.getName() + "=" + f.getValue());
    }

    public void logResultSet(ResultSet rs, String prefix) {
        if (rs == null) {
            this.log(prefix + "** ResultSet is NULL");
            return;
        }
        int index = 0;
        for (Row row : rs.getRow()) {
            this.log(prefix + this.m_lessThan + "row index=" + index++ + this.m_greaterThan);
            for (Field field : row.getField()) {
                this.logField(field, prefix + this.m_indent);
            }
            this.log(prefix + this.m_lessThan + "/row" + this.m_greaterThan);
        }
    }

    public void logException(Exception e) {
        e.printStackTrace(this.m_out);
        this.log(this.m_newLine);
    }

    public void log() {
        this.log(null);
    }

    public void log(String message) {
        this.m_out.print(message == null ? this.m_newLine : message + this.m_newLine);
        this.m_out.flush();
    }

    public void print(String message) {
        this.m_out.print(message);
        this.m_out.flush();
    }

    public String getDefaultIndent() {
        return this.m_indent;
    }

    public PrintWriter getPrintWriter() {
        return this.m_out;
    }

    public void close() {
        PrintWriter writer = this.getPrintWriter();
        writer.flush();
        if (this.isCloseWriter()) {
            writer.close();
        }
    }

    public void setCloseWriter(boolean closeWriter) {
        this.m_closeWriter = closeWriter;
    }

    public boolean isCloseWriter() {
        return this.m_closeWriter;
    }

    public static Object idcVersionInfo(Object arg) {
        return "releaseInfo=dev,releaseRevision=$Rev: 122354 $";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogFormat {
        console,
        html;

    }
}

