/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc;

import java.io.IOException;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcClientManager;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCVersionProperties;
import oracle.stellent.ridc.common.io.CloseNotifyInputStream;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.filter.IdcFilterType;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.model.impl.DataFactoryImpl;
import oracle.stellent.ridc.protocol.Connection;
import oracle.stellent.ridc.protocol.ConnectionManager;
import oracle.stellent.ridc.protocol.ConnectionPool;
import oracle.stellent.ridc.protocol.ConnectionPoolManager;
import oracle.stellent.ridc.protocol.Protocol;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.ServiceResponse;

public abstract class IdcClient<TConfig extends IdcClientConfig, TProtocol extends Protocol, TConnection extends Connection> {
    private final ILog m_log = LogFactory.getLog(this.getClass());
    private DataFactory m_dataFactory = new DataFactoryImpl();
    private TConfig m_clientConfig = null;
    private ConnectionPool<TConnection> m_connectionPool = null;
    private ConnectionManager<TConnection, TConfig> m_connectionManager = null;
    private volatile boolean m_initialized = false;
    private IdcClientManager m_clientManager = null;

    protected IdcClient(IdcClientManager clientManager, TConfig clientConfig) {
        this.m_clientManager = clientManager;
        this.m_clientConfig = clientConfig;
    }

    public synchronized void setInitialized(boolean initialized) {
        this.m_initialized = initialized;
    }

    public synchronized void initialize() throws IdcClientException {
        if (!this.isInitialized()) {
            this.m_connectionManager = this.createConnectionManager();
            this.m_connectionPool = this.createConnectionPool();
            this.setInitialized(true);
        }
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public IdcClientManager getClientManager() {
        return this.m_clientManager;
    }

    public DataFactory getDataFactory() {
        return this.m_dataFactory;
    }

    public DataBinder createBinder() {
        return this.getDataFactory().createBinder();
    }

    public void setDataFactory(DataFactory dataFactory) {
        this.m_dataFactory = dataFactory;
    }

    public TConfig getConfig() {
        return this.m_clientConfig;
    }

    public ConnectionPool<TConnection> getConnectionPool() throws ProtocolException {
        return this.m_connectionPool;
    }

    public ConnectionManager<TConnection, TConfig> getConnectionManager() {
        return this.m_connectionManager;
    }

    public ServiceResponse sendRequest(IdcContext userContext, DataBinder dataBinder) throws IdcClientException {
        if (!this.isInitialized()) {
            this.initialize();
        }
        TConnection connection = this.getConnectionPool().acquireConnection();
        boolean releaseConnection = false;
        ServiceRequest<TConnection> serviceRequest = null;
        ServiceLog<TConfig> slog = null;
        try {
            String useragent = ((IdcClientConfig)this.getConfig()).getProperty("User-Agent");
            if (!StringTools.isEmpty(useragent)) {
                userContext.setUserAgent(useragent);
            }
            serviceRequest = this.createRequest(userContext, dataBinder, connection);
            slog = new ServiceLog<TConfig>(this.getConfig(), serviceRequest, dataBinder);
            serviceRequest.setServiceLog(slog);
            slog.logStart();
            TProtocol protocol = this.createProtocol(serviceRequest);
            protocol.setFilterManager(this.getClientManager().getFilterManager());
            protocol.getFilterManager().executeFilters(IdcFilterType.beforeServiceRequest, this, userContext, dataBinder);
            protocol.writeRequest();
            ServiceResponse response = this.createResponse(serviceRequest, (Protocol)protocol, protocol.readResponse());
            slog.logStop();
            ServiceResponse serviceResponse = response;
            return serviceResponse;
        }
        catch (IdcClientException exp) {
            releaseConnection = true;
            throw exp;
        }
        catch (RuntimeException exp) {
            releaseConnection = true;
            throw exp;
        }
        finally {
            if (slog != null) {
                slog.logCleanup();
            }
            if (releaseConnection) {
                this.getConnectionPool().releaseConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(IdcContext userContext) throws IdcClientException {
        TConnection connection = this.getConnectionPool().acquireConnection();
        ServiceRequest<TConnection> serviceRequest = null;
        try {
            DataBinder dataBinder = this.createBinder();
            dataBinder.putLocal("IdcService", "LOGOUT");
            serviceRequest = this.createRequest(userContext, dataBinder, connection);
            TProtocol protocol = this.createProtocol(serviceRequest);
            protocol.setFilterManager(this.getClientManager().getFilterManager());
            protocol.getFilterManager().executeFilters(IdcFilterType.beforeLogout, this, userContext, dataBinder);
            protocol.logout();
        }
        catch (Exception ignore) {
        }
        finally {
            if (userContext != null) {
                userContext.clearCookies();
                userContext.clearHeaders();
                userContext.clearParameters();
                userContext.setCredentials(null);
                userContext = null;
            }
            this.getConnectionPool().releaseConnection(connection);
        }
    }

    protected abstract TProtocol createProtocol(ServiceRequest<TConnection> var1) throws ProtocolException;

    protected abstract ConnectionManager<TConnection, TConfig> createConnectionManager();

    protected ServiceRequest<TConnection> createRequest(IdcContext userContext, DataBinder dataBinder, TConnection connection) {
        return new ServiceRequest<TConnection>(userContext, dataBinder, connection);
    }

    protected ServiceResponse createResponse(final ServiceRequest<TConnection> request, Protocol protocol, ServiceResponse response) {
        response.setServiceLog(request.getServiceLog());
        response.setCloseMethod(new CloseNotifyInputStream.CloseMethod(){

            @Override
            public void close() throws IOException {
                block2: {
                    try {
                        IdcClient.this.getConnectionPool().releaseConnection(request.getConnection());
                    }
                    catch (ProtocolException exp) {
                        if (!exp.isIOException()) break block2;
                        throw (IOException)exp.getCause();
                    }
                }
            }
        });
        return response;
    }

    protected ConnectionPool<TConnection> createConnectionPool() throws ProtocolException {
        String model;
        ConnectionPoolManager connectionPoolManager = this.getClientManager().getConnectionPoolManager();
        if (!connectionPoolManager.isConnectionPoolRegistered(model = ((IdcClientConfig)this.getConfig()).getConnectionPool())) {
            this.m_log.log(RIDCMessages.connection_pool_threading_model_invalid(model), ILog.Level.WARN);
            model = "simple";
        }
        return connectionPoolManager.createConnectionPool(model, (IdcClientConfig)this.getConfig(), this.getConnectionManager());
    }

    public String getVersion() {
        return RIDCVersionProperties.getVersion();
    }

    public boolean isCompatible(String version) {
        return RIDCVersionProperties.isCompatible(version);
    }
}

