/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class IdcClientConfig {
    public static final String PROP_CONNECTION_URL = "connectionUrl";
    public static final String PROP_CONNECTION_SIZE = "connectionSize";
    public static final String PROP_CONNECTION_WAIT_TIME = "connectionWaitTime";
    public static final String PROP_CONNECTION_POOL = "connectionPool";
    public static final String PROP_SOCKET_TIMEOUT = "socketTimeout";
    public static final int PROP_SOCKET_TIMEOUT_DEFAULT = 60000;
    private Map<String, String> m_properties = new HashMap<String, String>();

    public void setProperties(Map<String, String> properties) {
        this.m_properties = properties;
    }

    public Collection<String> getPropertyNames() {
        return this.m_properties.keySet();
    }

    public void setProperty(String name, String value) {
        this.m_properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.m_properties.get(name);
    }

    public String getConnectionString() {
        return this.getProperty(PROP_CONNECTION_URL);
    }

    public void setConnectionString(String connectionString) {
        this.setProperty(PROP_CONNECTION_URL, connectionString);
    }

    public int getConnectionSize() {
        return this.getIntProperty(PROP_CONNECTION_SIZE, 20);
    }

    public void setConnectionSize(int size) {
        this.setProperty(PROP_CONNECTION_SIZE, String.valueOf(size));
    }

    public long getConnectionWaitTime() {
        return this.getLongProperty(PROP_CONNECTION_WAIT_TIME, 30000L);
    }

    public void setConnectionWaitTime(long waitTime) {
        this.setProperty(PROP_CONNECTION_WAIT_TIME, String.valueOf(waitTime));
    }

    public String getConnectionPool() {
        return this.getStringProperty(PROP_CONNECTION_POOL, "simple");
    }

    public void setConnectionPool(String model) {
        this.setProperty(PROP_CONNECTION_POOL, model);
    }

    public int getSocketTimeout() {
        return this.getIntProperty(PROP_SOCKET_TIMEOUT, 60000);
    }

    public void setSocketTimeout(int timeout) {
        this.setProperty(PROP_SOCKET_TIMEOUT, String.valueOf(timeout));
    }

    protected String getStringProperty(String name, String defaultValue) {
        String text = this.getProperty(name);
        if (text != null) {
            return text;
        }
        return defaultValue;
    }

    protected int getIntProperty(String name, int defaultValue) {
        String text = this.getProperty(name);
        if (text != null) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected long getLongProperty(String name, long defaultValue) {
        String text = this.getProperty(name);
        if (text != null) {
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected boolean getBooleanProperty(String name, boolean defaultValue) {
        String text = this.getProperty(name);
        if (text != null) {
            return "true".equalsIgnoreCase(text);
        }
        return defaultValue;
    }
}

