/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcClientProfile;
import oracle.stellent.ridc.IdcClientProvider;
import oracle.stellent.ridc.RIDCVersionProperties;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.filter.IIdcFilter;
import oracle.stellent.ridc.filter.IdcFilterManager;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.protocol.ConnectionPoolManager;
import oracle.stellent.ridc.protocol.http.IdcHttpClientProvider;
import oracle.stellent.ridc.protocol.intradoc.IntradocClientProvider;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientProvider;

public class IdcClientManager {
    public static final String WSDL_URL_IDENTIFIER = ".*/idcnativews/?\\s*";
    public static final String IDC_PROTOCOL = "idc";
    public static final String IDCS_PROTOCOL = "idcs";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String JAXWS_PROTOCOL = "jaxws";
    private static final ILog s_log = LogFactory.getLog(IdcClientManager.class);
    private final ConnectionPoolManager m_poolManager = new ConnectionPoolManager();
    private final Map<String, IdcClient> m_clients = new ConcurrentHashMap<String, IdcClient>();
    private final Map<String, IdcClientProvider> m_providers = new ConcurrentHashMap<String, IdcClientProvider>();
    private final IdcFilterManager m_filterManager = new IdcFilterManager();

    public IdcClientManager(IdcClientProfile clientProfile) {
        s_log.log("RIDC Version: " + RIDCVersionProperties.getVersion(), ILog.Level.DEBUG);
        switch (clientProfile) {
            case FULL: {
                IntradocClientProvider intradocProvider = new IntradocClientProvider();
                this.registerProvider(IDC_PROTOCOL, intradocProvider);
                this.registerProvider(IDCS_PROTOCOL, intradocProvider);
                this.registerProvider(JAXWS_PROTOCOL, new JaxWSClientProvider());
            }
        }
        IdcHttpClientProvider httpClientProvider = new IdcHttpClientProvider();
        this.registerProvider(HTTP_PROTOCOL, httpClientProvider);
        this.registerProvider(HTTPS_PROTOCOL, httpClientProvider);
        this.registerDmsFilter();
    }

    protected void registerDmsFilter() {
        try {
            IIdcFilter dmsFilter = (IIdcFilter)Class.forName("oracle.stellent.ridc.filter.dms.DmsFilter").newInstance();
            this.m_filterManager.registerFilter(0, dmsFilter);
        }
        catch (Throwable e) {
            s_log.log("DMS filter cannot be instantiated", e, ILog.Level.WARN);
        }
    }

    public IdcClientManager() {
        this(IdcClientProfile.FULL);
    }

    public void registerProvider(String protocol, IdcClientProvider provider) {
        this.m_providers.put(protocol, provider);
    }

    public IdcClientProvider getProvider(String protocol) {
        return this.m_providers.get(protocol);
    }

    public IdcClientProvider getProvider(String protocol, String url) {
        if (!StringTools.isEmpty(url) && this.m_providers.containsKey(JAXWS_PROTOCOL) && url.matches(WSDL_URL_IDENTIFIER)) {
            protocol = JAXWS_PROTOCOL;
        }
        return this.getProvider(protocol);
    }

    public ConnectionPoolManager getConnectionPoolManager() {
        return this.m_poolManager;
    }

    public IdcFilterManager getFilterManager() {
        return this.m_filterManager;
    }

    public IdcClient createClient(String url) throws IdcClientException {
        int index = url.indexOf("://");
        if (index != -1) {
            String protocol = url.substring(0, index);
            IdcClientProvider provider = this.getProvider(protocol, url);
            if (provider == null) {
                throw new IdcClientException(RIDCMessages.client_no_provider_for_protocol(protocol));
            }
            return provider.createClient(this, url);
        }
        throw new IdcClientException(RIDCMessages.client_invalid_url(url));
    }

    public IdcClient getClient(String name) {
        return this.m_clients.get(name);
    }

    public void addClient(String name, IdcClient client) {
        this.m_clients.put(name, client);
    }

    public void removeClient(String name) {
        this.m_clients.remove(name);
    }

    public Collection<String> getClientNames() {
        if (this.m_clients == null) {
            return Collections.emptyList();
        }
        return this.m_clients.keySet();
    }
}

