/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.auth.impl.BasicCredentials;
import oracle.stellent.ridc.auth.impl.UserNameOnlyCredentials;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class IdcContext {
    public static final String USER_AGENT = "Java; Stellent CIS 11g";
    public static final String JSESSION_ID = "JSESSIONID";
    public static final String UCM_SESSION_ID = "IDCCS_SESSIONID";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static LoginForm JAAS_FORM = new LoginForm("j_username", "j_password", "j_security_check", "POST");
    public static LoginForm OAM_SSO_FORM = new LoginForm("userid", "password", "/access/sso", "POST");
    public static LoginForm OIM_SSO_FORM = new LoginForm("ssousername", "password", "/sso/auth", "POST");
    public static final String DEFAULT_USER = "anonymous";
    private Credentials m_credentials = null;
    private String m_encoding = null;
    private String m_userAgent = "Java; Stellent CIS 11g";
    private final Map<String, String> m_headers = new ConcurrentHashMap<String, String>(4, 0.9f, 1);
    private volatile Map<String, RIDCCookie> m_cookies = null;
    private LoginForm m_loginForm = null;
    private HttpAuthScheme m_authScheme = null;
    private String m_sessionCookie = "JSESSIONID";
    private final Map<String, Object> m_parameters = new ConcurrentHashMap<String, Object>(4, 0.9f, 1);

    public IdcContext() {
        this(DEFAULT_USER);
    }

    public IdcContext(String user) {
        this.m_credentials = new UserNameOnlyCredentials(user);
    }

    public IdcContext(String user, String password) {
        this.m_credentials = new BasicCredentials(user, password);
    }

    public IdcContext(Credentials credentials) {
        this.m_credentials = credentials;
    }

    @Deprecated
    public IdcContext(String user, Credentials credentials) {
        this(credentials);
        if (credentials == null) {
            this.m_credentials = new UserNameOnlyCredentials(user);
            return;
        }
        if (user == null) {
            this.m_credentials = credentials;
            return;
        }
        if (!user.equals(this.getCredentials().getUserName())) {
            throw new IllegalArgumentException(RIDCMessages.context_construction_error().toString());
        }
    }

    public String getUser() throws IllegalArgumentException {
        if (this.m_credentials == null) {
            throw new IllegalArgumentException(RIDCMessages.null_credentials().toString());
        }
        return this.m_credentials.getUserName();
    }

    @Deprecated
    public void setUser(String user) {
        throw new IllegalArgumentException(RIDCMessages.invalid_method("IdcContext.setUserName()").toString());
    }

    public boolean hasCredentials() {
        return this.m_credentials != null;
    }

    public Credentials getCredentials() {
        return this.m_credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.m_credentials = credentials;
    }

    public String getEncoding() {
        if (this.m_encoding == null) {
            this.m_encoding = DEFAULT_ENCODING;
        }
        return this.m_encoding;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.m_userAgent = userAgent;
    }

    public LoginForm getLoginForm() {
        return this.m_loginForm;
    }

    public void setLoginForm(LoginForm loginForm) {
        this.m_loginForm = loginForm;
    }

    public HttpAuthScheme getAuthScheme() {
        return this.m_authScheme;
    }

    public void setAuthScheme(HttpAuthScheme authScheme) {
        this.m_authScheme = authScheme;
    }

    public String getSessionCookie() {
        return this.m_sessionCookie;
    }

    public void setSessionCookie(String sessionCookie) {
        this.m_sessionCookie = sessionCookie;
    }

    public void addHeader(String name, String value) {
        this.m_headers.put(name, value);
    }

    public String getHeader(String name) {
        return this.m_headers.get(name);
    }

    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.m_headers.keySet());
    }

    public void clearHeaders() {
        this.m_headers.clear();
    }

    public Map<String, String> getHeaders() {
        return this.m_headers;
    }

    @Deprecated
    public void addCookie(RIDCCookie cookie) {
        HashMap<String, RIDCCookie> cookies = new HashMap<String, RIDCCookie>();
        cookies.putAll(this.getCookies());
        cookies.put(cookie.getName(), cookie);
        this.setCookies(cookies);
    }

    public void setCookies(Map<String, RIDCCookie> cookies) {
        this.m_cookies = Collections.unmodifiableMap(cookies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RIDCCookie> getCookies() {
        Map<String, RIDCCookie> cookies = this.m_cookies;
        if (cookies == null) {
            IdcContext idcContext = this;
            synchronized (idcContext) {
                cookies = this.m_cookies;
                if (cookies == null) {
                    this.m_cookies = cookies = Collections.emptyMap();
                }
            }
        }
        return cookies;
    }

    public RIDCCookie getCookie(String name) {
        return this.m_cookies != null ? this.m_cookies.get(name) : null;
    }

    public Set<String> getCookieNames() {
        if (this.m_cookies != null) {
            return Collections.unmodifiableSet(this.m_cookies.keySet());
        }
        return Collections.emptySet();
    }

    public void clearCookies() {
        this.m_cookies = Collections.emptyMap();
    }

    public void setParameter(String name, Object value) {
        this.m_parameters.put(name, value);
    }

    public Object getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public String getParameterAsString(String name) {
        String result = null;
        Object value = this.getParameter(name);
        if (value != null) {
            result = value instanceof String ? (String)value : (value instanceof Boolean ? ((Boolean)value != false ? "true" : "false") : (value instanceof Integer ? String.valueOf(value) : value.toString()));
        }
        return result;
    }

    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.m_parameters.keySet());
    }

    public void clearParameters() {
        this.m_parameters.clear();
    }

    public Map<String, Object> getParameters() {
        return this.m_parameters;
    }

    public static class LoginForm {
        private String m_usernameField = null;
        private String m_passwordField = null;
        private String m_actionUrl = null;
        private String m_httpMethod = null;
        private Map<String, String> m_parameters = null;

        public LoginForm(String usernameField, String passwordField, String actionUrl, String httpMethod) {
            this(usernameField, passwordField, actionUrl, httpMethod, null);
        }

        public LoginForm(String usernameField, String passwordField, String actionUrl, String httpMethod, Map<String, String> parameters) {
            this.m_usernameField = usernameField;
            this.m_passwordField = passwordField;
            this.m_actionUrl = actionUrl;
            this.m_httpMethod = httpMethod;
            this.m_parameters = parameters;
            if (this.m_parameters == null) {
                this.m_parameters = Collections.emptyMap();
            }
        }

        public String getActionUrl() {
            return this.m_actionUrl;
        }

        public String getHttpMethod() {
            return this.m_httpMethod;
        }

        public String getUsernameField() {
            return this.m_usernameField;
        }

        public String getPasswordField() {
            return this.m_passwordField;
        }

        public Map<String, String> getParameters() {
            return this.m_parameters;
        }
    }

    public static enum HttpAuthScheme {
        BasicAuth,
        LoginForm,
        OAM_SSO,
        OAM_11G_WG,
        OIM_SSO,
        CUSTOM;

    }
}

