/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc;

public class RIDCCookie {
    private String m_domain = null;
    private String m_name = null;
    private String m_value = null;
    private String m_path = null;
    private int m_maxAge = -1;
    private boolean m_secure = false;
    private String m_comment = null;

    public RIDCCookie(String name, String value) {
        this.m_name = name;
        this.m_value = value;
        this.m_domain = "";
        this.m_path = "/";
    }

    public RIDCCookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        this.m_domain = domain;
        this.m_name = name;
        this.m_value = value;
        this.m_path = path;
        this.m_maxAge = maxAge;
        this.m_secure = secure;
    }

    public RIDCCookie(String cookieString) {
        String[] fields = cookieString.split(";\\s*");
        String cookieValue = fields[0];
        for (int j = 1; j < fields.length; ++j) {
            String[] f;
            if ("secure".equalsIgnoreCase(fields[j])) {
                this.setSecure(true);
                continue;
            }
            if (fields[j].indexOf(61) <= 0 || "expires".equalsIgnoreCase((f = fields[j].split("="))[0])) continue;
            if ("domain".equalsIgnoreCase(f[0])) {
                this.setDomain(f[1]);
                continue;
            }
            if (!"path".equalsIgnoreCase(f[0])) continue;
            this.setPath(f[1]);
        }
        if (cookieValue.indexOf("=") > 0) {
            String[] f = cookieValue.split("=");
            this.setName(f[0]);
            this.setValue(f[1]);
        }
    }

    public String getDomain() {
        return this.m_domain;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public int getMaxAge() {
        return this.m_maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.m_maxAge = maxAge;
    }

    public boolean isSecure() {
        return this.m_secure;
    }

    public void setSecure(boolean secure) {
        this.m_secure = secure;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public String toString() {
        String cookieString = "";
        cookieString = cookieString + this.getName() + "=" + this.getValue();
        cookieString = cookieString + "; path=" + this.getPath();
        return cookieString;
    }
}

