/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc;

import java.util.ArrayList;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class RIDCVersionProperties {
    public static String getVersion() {
        return "11.1.1.7.1.8008";
    }

    public static boolean isCompatible(String reqVersion) throws NumberFormatException {
        ArrayList<Integer> required = new ArrayList<Integer>();
        ArrayList<Integer> library = new ArrayList<Integer>();
        String libVersion = RIDCVersionProperties.getVersion();
        if (!StringTools.isEmpty(libVersion)) {
            for (String part : libVersion.split("\\.")) {
                library.add(new Integer(part));
            }
        }
        if (!StringTools.isEmpty(reqVersion)) {
            for (String part : reqVersion.split("\\.")) {
                required.add(new Integer(part));
            }
        }
        if (required.size() > library.size()) {
            throw new NumberFormatException(RIDCMessages.required_version_more_specific(reqVersion, libVersion).toString());
        }
        for (int i = 0; i < required.size() && (Integer)library.get(i) <= (Integer)required.get(i); ++i) {
            if ((Integer)required.get(i) <= (Integer)library.get(i)) continue;
            return false;
        }
        return true;
    }
}

