/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.auth;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import oracle.stellent.ridc.auth.Credentials;

public enum CredentialsType {
    basic,
    nameonly,
    appid,
    adf;

    private static final Map<String, CredentialsType> lookup;

    public static CredentialsType getCredentialsType(String credentialsType) {
        if (credentialsType == null) {
            return null;
        }
        return lookup.get(credentialsType);
    }

    public static CredentialsType getCredentialsType(Credentials credentials) {
        if (credentials == null) {
            return null;
        }
        CredentialsType type = null;
        if (credentials instanceof Credentials.BasicCredentials) {
            type = basic;
        } else if (credentials instanceof Credentials.UserNameOnlyCredentials) {
            type = nameonly;
        } else if (credentials instanceof Credentials.AppIdClientCredentials) {
            type = appid;
        } else if (credentials instanceof Credentials.AdfUserCredentials) {
            type = adf;
        }
        return type;
    }

    static {
        lookup = new HashMap<String, CredentialsType>();
        for (CredentialsType t : EnumSet.allOf(CredentialsType.class)) {
            lookup.put(t.name(), t);
        }
    }
}

