/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.http.impl;

import oracle.stellent.ridc.common.http.RIDCHttpPart;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.model.TransferFile;

public class RIDCHttpPartImpl<T>
implements RIDCHttpPart<T> {
    private String name;
    private T content;
    private String encoding;

    public RIDCHttpPartImpl(String name, T content) {
        this.name = name;
        this.content = content;
    }

    public RIDCHttpPartImpl(String name, T content, String encoding) {
        this(name, content);
        this.encoding = encoding;
    }

    @Override
    public T getContent() {
        return this.content;
    }

    @Override
    public RIDCHttpPart.PartType getType() {
        if (this.content instanceof TransferFile) {
            return RIDCHttpPart.PartType.TRANSFERFILE;
        }
        if (this.content instanceof String) {
            return RIDCHttpPart.PartType.STRING;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getEncoding() {
        if (StringTools.isEmpty(this.encoding)) {
            this.encoding = "UTF-8";
        }
        return this.encoding;
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

