/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.http.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import oracle.stellent.ridc.common.http.RIDCHttpPart;
import oracle.stellent.ridc.common.util.StreamUtil;
import oracle.stellent.ridc.model.TransferFile;

public final class Multipart {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] LINE_BREAK = new byte[]{13, 10};
    private static final byte[] DASH_DASH = new byte[]{45, 45};

    public static long getContentLength(List<RIDCHttpPart<?>> parts, String boundary) throws UnsupportedEncodingException {
        int boundaryLen = boundary.getBytes(UTF_8).length + 4;
        long size = 0L;
        for (RIDCHttpPart<?> part : parts) {
            long partSize = Multipart.getSize(part);
            if (partSize < 0L) {
                return -1L;
            }
            size += (long)boundaryLen + partSize;
        }
        return size += (long)(boundaryLen + 2);
    }

    public static void write(OutputStream out, List<RIDCHttpPart<?>> parts, String boundary) throws IOException {
        byte[] boundaryBytes = boundary.getBytes(UTF_8);
        for (RIDCHttpPart<?> part : parts) {
            out.write(DASH_DASH);
            out.write(boundaryBytes);
            out.write(LINE_BREAK);
            Multipart.writePart(out, part);
        }
        out.write(DASH_DASH);
        out.write(boundaryBytes);
        out.write(DASH_DASH);
        out.write(LINE_BREAK);
    }

    static String[] getHeaders(RIDCHttpPart<?> part) {
        String contentDisposition;
        String contentType;
        switch (part.getType()) {
            case STRING: {
                contentType = "Content-Type: text/plain; charset=" + part.getEncoding();
                contentDisposition = "Content-Disposition: form-data; name=\"" + part.getName() + "\"";
                break;
            }
            case TRANSFERFILE: {
                TransferFile file = (TransferFile)part.getContent();
                contentType = "Content-Type: " + file.getContentType();
                contentDisposition = "Content-Disposition: form-data; name=\"" + part.getName() + "\"; filename=\"" + file.getFileName() + "\"";
                break;
            }
            default: {
                throw new IllegalArgumentException(part.getType().toString());
            }
        }
        return new String[]{contentDisposition, contentType};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeContent(OutputStream out, RIDCHttpPart<?> part) throws IOException {
        switch (part.getType()) {
            case STRING: {
                String content = (String)part.getContent();
                out.write(content.getBytes(part.getEncoding()));
                break;
            }
            case TRANSFERFILE: {
                out.flush();
                TransferFile file = (TransferFile)part.getContent();
                byte[] buffer = new byte[16384];
                InputStream in = file.getInputStream();
                try {
                    int read = 0;
                    while ((read = in.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                        file.notifyBufferWrite(read);
                    }
                    break;
                }
                finally {
                    StreamUtil.closeStream(in);
                }
            }
            default: {
                throw new IllegalArgumentException(part.getType().toString());
            }
        }
    }

    static long getSize(RIDCHttpPart<?> part) throws UnsupportedEncodingException {
        long size = 0L;
        switch (part.getType()) {
            case STRING: {
                String content = (String)part.getContent();
                size = content.getBytes(part.getEncoding()).length;
                break;
            }
            case TRANSFERFILE: {
                TransferFile file = (TransferFile)part.getContent();
                size = file.getContentLength();
                if (size > 0L) break;
                return -1L;
            }
            default: {
                throw new IllegalArgumentException(part.getType().toString());
            }
        }
        size += 4L;
        for (String header : Multipart.getHeaders(part)) {
            size += (long)(2 + header.getBytes(UTF_8).length);
        }
        return size;
    }

    static void writePart(OutputStream out, RIDCHttpPart<?> part) throws IOException {
        for (String header : Multipart.getHeaders(part)) {
            out.write(header.getBytes(UTF_8));
            out.write(LINE_BREAK);
        }
        out.write(LINE_BREAK);
        Multipart.writeContent(out, part);
        out.write(LINE_BREAK);
    }
}

