/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.http.utils;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.utils.RIDCHttpConstants;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.common.util.VersionManifest;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConfig;
import oracle.stellent.ridc.protocol.http.apache3.impl.HttpApache3Client;
import oracle.stellent.ridc.protocol.http.apache4.impl.HttpApache4Client;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.HttpURLConnectionClient;
import oracle.stellent.ridc.protocol.http.oracle.impl.HttpOracleClient;

public class RIDCHttpClientUtils {
    private static ILog s_log = LogFactory.getLog(RIDCHttpClientUtils.class);

    public static RIDCHttpClient createHttpClient(IdcHttpClientConfig config, boolean multithreaded) throws IdcClientException {
        RIDCHttpConstants.HttpLibrary library = config.getHttpLibrary();
        s_log.log("Creating RIDC HTTP Client with stack :" + library.name(), ILog.Level.DEBUG);
        RIDCHttpClient client = null;
        switch (library) {
            case apache3: {
                client = new HttpApache3Client(multithreaded);
                break;
            }
            case apache4: {
                client = new HttpApache4Client();
                break;
            }
            case oracle: {
                client = new HttpOracleClient(config);
                break;
            }
            case httpurlconnection: {
                client = new HttpURLConnectionClient(config);
            }
        }
        if (client == null) {
            throw new IdcClientException(RIDCMessages.http_utils_invalid_client_lib((Object)config.getHttpLibrary()));
        }
        client.setSocketTimeout(config.getSocketTimeout());
        String proxyHost = RIDCHttpClientUtils.getProxy(config);
        if (!StringTools.isEmpty(proxyHost)) {
            if (!StringTools.isEmpty(config.getProxyUsername())) {
                client.setProxy(proxyHost, config.getProxyPort(), config.getProxyUsername(), config.getProxyPassword(), config.getProxyRealm());
            } else {
                client.setProxy(proxyHost, config.getProxyPort(), null, null, null);
            }
        }
        return client;
    }

    private static String getProxy(IdcHttpClientConfig clientConfig) {
        try {
            boolean end;
            String proxy = clientConfig.getProxyHost();
            String nonProxy = clientConfig.getNonProxyHosts();
            URI uri = new URI(clientConfig.getConnectionString());
            if (StringTools.isEmpty(nonProxy)) {
                return proxy;
            }
            String machine = uri.getHost();
            int nonStart = nonProxy.charAt(0) == '|' ? 1 : 0;
            boolean bl = end = nonStart >= nonProxy.length();
            while (!end) {
                String nonProxyM;
                int nonEnd = nonProxy.indexOf(124, nonStart);
                if (nonEnd == -1) {
                    end = true;
                    nonEnd = nonProxy.length();
                }
                if ((nonProxyM = nonProxy.substring(nonStart, nonEnd).trim()).charAt(0) == '*' && machine.indexOf(nonProxyM.substring(1)) > -1 || nonProxyM.equals(machine)) {
                    return null;
                }
                nonStart = nonEnd + 1;
            }
            return proxy;
        }
        catch (Exception e) {
            s_log.log(RIDCMessages.protocol_proxy_exception(e.getMessage()), ILog.Level.WARN);
            return null;
        }
    }

    public static void addRequestData(IdcContext context, RIDCHttpClient httpClient, RIDCHttpMethod httpMethod, boolean addCookies) {
        if (!StringTools.isEmpty(context.getUserAgent())) {
            httpMethod.addRequestHeader("User-Agent", context.getUserAgent());
        }
        httpMethod.setCookiePolicy("idcAllCookies");
        if (context.getParameters().size() > 0) {
            for (String string : context.getParameterNames()) {
                String value = context.getParameterAsString(string);
                if (value == null) continue;
                httpMethod.setParameter(string, value);
            }
        }
        httpMethod.addRequestHeader("IdcVersion", VersionManifest.getImplementationVersion());
        if (context.getHeaders().size() > 0) {
            for (Map.Entry entry : context.getHeaders().entrySet()) {
                String header = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                httpMethod.addRequestHeader(header, value);
            }
        }
        if (addCookies) {
            for (Map.Entry entry : context.getCookies().entrySet()) {
                RIDCCookie cookie;
                block10: {
                    String name = (String)entry.getKey();
                    cookie = (RIDCCookie)entry.getValue();
                    String domain = cookie.getDomain();
                    if (StringTools.isEmpty(domain)) {
                        try {
                            domain = httpMethod.getURI().getHost();
                        }
                        catch (Exception exp) {
                            if (!s_log.isLogEnabled(ILog.Level.DEBUG)) break block10;
                            s_log.log(String.format("Unable to set default domain for cookie '%s'", name), (Throwable)exp, ILog.Level.DEBUG);
                        }
                    }
                }
                httpClient.addCookie(cookie);
            }
        }
    }

    public static Map<String, String> getResponseHeaders(List<RIDCHttpHeader> headers) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (headers != null) {
            try {
                for (RIDCHttpHeader header : headers) {
                    headerMap.put(header.getName(), header.getValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return headerMap;
    }

    public static boolean isRedirectStatus(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }
}

