/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthLimitedInputStream
extends FilterInputStream {
    private long m_length;
    private long m_numLeft;
    private long m_markLeft = -1L;

    public LengthLimitedInputStream(InputStream is, long length) {
        super(is);
        this.m_length = length;
        this.m_numLeft = length;
    }

    public long getContentLength() {
        return this.m_length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int numRead;
        if (this.m_numLeft <= 0L) {
            return -1;
        }
        long numToRead = this.m_numLeft;
        if (numToRead > (long)len) {
            numToRead = len;
        }
        if ((numRead = super.read(b, off, (int)numToRead)) > 0) {
            this.m_numLeft -= (long)numRead;
        }
        return numRead;
    }

    @Override
    public int read() throws IOException {
        if (this.m_numLeft <= 0L) {
            return -1;
        }
        int ret = super.read();
        this.m_numLeft = ret == -1 ? 0L : --this.m_numLeft;
        return ret;
    }

    @Override
    public int available() throws IOException {
        if (this.m_numLeft <= 0L) {
            return 0;
        }
        int available = super.available();
        if ((long)available > this.m_numLeft) {
            available = (int)this.m_numLeft;
        }
        return available;
    }

    @Override
    public long skip(long n) throws IOException {
        long numSkipped;
        if (this.m_numLeft <= 0L) {
            return 0L;
        }
        long numToSkip = this.m_numLeft;
        if (numToSkip > n) {
            numToSkip = n;
        }
        if ((numSkipped = super.skip(numToSkip)) > 0L) {
            this.m_numLeft -= numSkipped;
        }
        return numSkipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.m_markLeft = this.m_numLeft;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.m_numLeft = this.m_markLeft;
    }
}

