/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.log.jdk;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.impl.BaseLogSupport;

public class JDKLog
extends BaseLogSupport {
    protected Logger m_logger = null;

    public JDKLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public void log(String message, ILog.Level level) {
        this.log(message, null, level);
    }

    @Override
    public void log(String message, Throwable error, ILog.Level level) {
        Level loggerLevel = this.getLoggingLevel(level);
        if (this.m_logger.isLoggable(loggerLevel)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String cname = "unknown";
            String method = "unknown";
            if (locations != null && locations.length > 2) {
                StackTraceElement caller = locations[2];
                cname = caller.getClassName();
                method = caller.getMethodName();
            }
            LogRecord record = new LogRecord(loggerLevel, message);
            record.setThrown(error);
            record.setSourceClassName(cname);
            record.setSourceMethodName(method);
            this.m_logger.log(record);
        }
    }

    @Override
    public boolean isLogEnabled(ILog.Level level) {
        Level loggerLevel = this.getLoggingLevel(level);
        return this.m_logger.isLoggable(loggerLevel);
    }

    protected Level getLoggingLevel(ILog.Level level) {
        Level loggerLevel = null;
        switch (level) {
            case TRACE: {
                loggerLevel = Level.FINER;
                break;
            }
            case DEBUG: {
                loggerLevel = Level.FINE;
                break;
            }
            case INFO: {
                loggerLevel = Level.INFO;
                break;
            }
            case WARN: {
                loggerLevel = Level.WARNING;
                break;
            }
            default: {
                loggerLevel = Level.SEVERE;
            }
        }
        return loggerLevel;
    }
}

