/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.log.simple;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.impl.BaseLogSupport;

public class SimpleLog
extends BaseLogSupport {
    protected String m_category = null;
    protected String m_categoryName = null;

    public SimpleLog(String category) {
        this.m_category = category;
        this.m_categoryName = category;
        int index = this.m_category.lastIndexOf(46);
        this.m_categoryName = index != -1 ? this.m_category.substring(index + 1) : this.m_category;
    }

    @Override
    public void log(String message, ILog.Level level) {
        this.log(message, null, level);
    }

    @Override
    public void log(String message, Throwable error, ILog.Level level) {
        this.outputMessage(level, this.formatMessage(message, error, level));
    }

    @Override
    public boolean isLogEnabled(ILog.Level level) {
        return true;
    }

    protected void outputMessage(ILog.Level level, String message) {
        System.out.println(message);
    }

    protected String formatMessage(String message, Throwable error, ILog.Level level) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%s] [%s] %s (%s): %s", DateFormat.getDateTimeInstance().format(new Date()), Thread.currentThread().getName(), this.m_categoryName, level.name(), message));
        if (error != null) {
            sb.append("\r\n");
            sb.append(String.format("[%s] [%s] %s (%s): %s", DateFormat.getDateTimeInstance().format(new Date()), Thread.currentThread().getName(), this.m_categoryName, level.name(), error.getMessage()));
            sb.append("\r\n");
            StringWriter sw = new StringWriter();
            error.printStackTrace(new PrintWriter(sw));
            sb.append(sw.toString());
        }
        return sb.toString();
    }
}

