/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.log.simple;

import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.log.Timer;
import oracle.stellent.ridc.common.util.ServiceLog;

public final class TimerImpl
implements Timer {
    private static ILog s_log = LogFactory.getLog(ServiceLog.class);
    private final String id = String.format("%s", ServiceLog.toId(System.nanoTime()));
    private final String name;
    private final String desc;
    private long startTime = 0L;
    private long elaspedTime = 0L;

    TimerImpl(String tname, String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public long getElaspedTimeNS() {
        return this.elaspedTime;
    }

    public float getElapsedTimeMS() {
        float time = 0.0f;
        if (this.elaspedTime > 0L) {
            time = (float)this.elaspedTime / 1000000.0f;
        }
        return time;
    }

    @Override
    public String getElapsedTimeString() {
        return String.format("Elapsed time for %s: [%s] %s time: %f ms", this.id, this.name, this.desc, Float.valueOf(this.getElapsedTimeMS()));
    }

    @Override
    public void cleanup() {
        this.startTime = 0L;
        this.elaspedTime = 0L;
    }

    @Override
    public void start() {
        this.startTime = System.nanoTime();
        s_log.log(String.format("Start timer for %s: [%s]", this.id, this.name, this.desc), ILog.Level.TRACE);
    }

    @Override
    public void stop() {
        this.elaspedTime = System.nanoTime() - this.startTime;
        s_log.log(String.format("Stop timer for %s: [%s]", this.id, this.name, this.desc), ILog.Level.TRACE);
    }
}

