/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.stellent.ridc.common.util.NameValuePair;

public abstract class HttpUtils {
    public static Map<String, String> createParametersFromQuery(String queryString) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (queryString != null) {
            String[] queryParams;
            for (String queryParam : queryParams = queryString.split("&")) {
                String[] nameValue = queryParam.split("=");
                try {
                    String name = nameValue[0];
                    String value = null;
                    if (nameValue.length > 1) {
                        value = URLDecoder.decode(nameValue[1], "UTF-8");
                    }
                    queryParameters.put(name, value);
                }
                catch (UnsupportedEncodingException exp) {
                    throw new RuntimeException(exp);
                }
            }
        }
        return queryParameters;
    }

    public static String createQueryFromParameters(Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        for (String name : parameters.keySet()) {
            String value = parameters.get(name);
            sb.append("&");
            sb.append(name);
            sb.append("=");
            if (value == null) continue;
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException exp) {
                throw new RuntimeException(exp);
            }
        }
        return sb.substring(1);
    }

    public static List<NameValuePair> convertToNVPairs(String query) {
        Map<String, String> params = HttpUtils.createParametersFromQuery(query);
        ArrayList<NameValuePair> nvPairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> e : params.entrySet()) {
            nvPairs.add(new NameValuePair(e.getKey(), e.getValue()));
        }
        return nvPairs;
    }

    public static URI replaceQueryString(URI uri, String queryString) {
        String uriString = uri.toString();
        if (uriString.indexOf("?") > 0) {
            uriString = uriString.substring(0, uriString.indexOf("?"));
        }
        uriString = uriString + "?" + queryString;
        return URI.create(uriString);
    }
}

