/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public final class ISO8601 {
    public static Calendar parseISO8601(String str) throws ParseException {
        return ISO8601.parseISO8601(str, null);
    }

    public static Calendar parseISO8601(String str, TimeZone tz) throws ParseException {
        int len = 4;
        int year = str.charAt(0) == '+' ? ISO8601.readInt(str, 1, len++) : (str.charAt(0) == '-' ? -ISO8601.readInt(str, 1, len++) : ISO8601.readInt(str, 0, len));
        ISO8601.readChar(str, '-', len++);
        int month = ISO8601.readInt(str, len, 2);
        len += 2;
        ISO8601.readChar(str, '-', len++);
        int day = ISO8601.readInt(str, len, 2);
        len += 2;
        ISO8601.readChar(str, 'T', ' ', len++);
        int hours = ISO8601.readInt(str, len, 2);
        len += 2;
        ISO8601.readChar(str, ':', len++);
        int minutes = ISO8601.readInt(str, len, 2);
        len += 2;
        ISO8601.readChar(str, ':', len++);
        int seconds = ISO8601.readInt(str, len, 2);
        int milliSeconds = 0;
        if (ISO8601.canReadChar(str, '.', len += 2)) {
            milliSeconds = ISO8601.readInt(str, ++len, 3);
            len += 3;
        }
        if (len < str.length()) {
            tz = ISO8601.readTimeZone(str, len);
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hours, minutes, seconds);
        ((Calendar)cal).setTimeZone(tz);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)milliSeconds);
        return cal;
    }

    private static void readChar(String str, char ch, int pos) throws ParseException {
        if (!ISO8601.canReadChar(str, ch, pos)) {
            throw new ParseException(RIDCMessages.util_iso8601_unable_to_read_char(Character.valueOf(ch)).toString(), pos);
        }
    }

    private static void readChar(String str, char ch1, char ch2, int pos) throws ParseException {
        if (!ISO8601.canReadChar(str, ch1, pos) && !ISO8601.canReadChar(str, ch2, pos)) {
            throw new ParseException(RIDCMessages.util_iso8601_unable_to_read_char(Character.valueOf(ch1)).toString(), pos);
        }
    }

    private static boolean canReadChar(String str, char ch, int pos) {
        return pos < str.length() && str.charAt(pos) == ch;
    }

    private static int readInt(String str, int start, int length) throws ParseException {
        if (str.length() < start + length) {
            throw new ParseException(RIDCMessages.util_iso8601_unexpected_end_of_string(str).toString(), start);
        }
        int value = 0;
        for (int i = start; i < start + length; ++i) {
            char ch = str.charAt(i);
            if (ch < '0' || ch > '9') {
                throw new ParseException(RIDCMessages.util_iso8601_char_not_an_integer(Character.valueOf(ch)).toString(), i);
            }
            value = value * 10 + (ch - 48);
        }
        return value;
    }

    private static TimeZone readTimeZone(String str, int start) throws ParseException {
        if (str.length() <= start) {
            throw new ParseException(RIDCMessages.util_iso8601_unexpected_end_of_string(str).toString(), start);
        }
        if (str.charAt(start) == 'Z' && str.length() == start + 1) {
            return TimeZone.getTimeZone("GMT");
        }
        if ((str.charAt(start) == '+' || str.charAt(start) == '-') && str.length() == start + 6) {
            return TimeZone.getTimeZone("GMT" + str.substring(start));
        }
        throw new ParseException(RIDCMessages.util_iso8601_invalid_timezone_char(Character.valueOf(str.charAt(start))).toString(), start);
    }
}

