/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.util;

import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.log.Timer;
import oracle.stellent.ridc.common.log.TimerProvider;
import oracle.stellent.ridc.common.log.simple.SimpleTimerProvider;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.protocol.ServiceRequest;

public final class ServiceLog<TConfig extends IdcClientConfig> {
    private static ILog s_log = LogFactory.getLog(ServiceLog.class);
    private final TConfig m_clientConfig;
    private final ServiceRequest m_serviceRequest;
    private final DataBinder m_requestBinder;
    private String id;
    private final Timer timer;
    private static TimerProvider s_timerProvider = null;

    public ServiceLog(TConfig clientConfig, ServiceRequest serviceRequest, DataBinder requestBinder) {
        this.m_clientConfig = clientConfig;
        this.m_serviceRequest = serviceRequest;
        this.m_requestBinder = requestBinder;
        String service = this.m_serviceRequest.getService();
        this.timer = ServiceLog.getTimerProvider().createTimer("request", service, "send Request");
    }

    public void logStart() {
        this.timer.start();
        if (s_log.isLogEnabled(ILog.Level.TRACE)) {
            String connectionString = ((IdcClientConfig)this.m_clientConfig).getConnectionString();
            if (this.m_serviceRequest.getUserContext().hasCredentials()) {
                Credentials credentials = this.m_serviceRequest.getUserContext().getCredentials();
                s_log.log(String.format("[>>]%s [%s] <%s> %s{%s}", this.getLogId(), this.m_requestBinder.getLocal("IdcService"), connectionString, credentials.getCredentialsClassName(), credentials.getLogId()), ILog.Level.TRACE);
            }
        }
    }

    public void logStop() {
        this.timer.stop();
        if (s_log.isLogEnabled(ILog.Level.TRACE)) {
            s_log.log(String.format("[<<]%s %s", this.getLogId(), this.timer.getElapsedTimeString()), ILog.Level.TRACE);
        }
    }

    public void logCleanup() {
        this.timer.cleanup();
    }

    public void logResponseBinder(DataBinder binder) {
        if (s_log.isLogEnabled(ILog.Level.TRACE)) {
            s_log.log(String.format("[<-]%s [RESPONSE BINDER]\n%s", this.getLogId(), binder), ILog.Level.TRACE);
        }
    }

    public void logExceptionResponse(String message) {
        if (s_log.isLogEnabled(ILog.Level.TRACE)) {
            s_log.log(String.format("[<>]%s [%s] Exception(%s)", this.getLogId(), this.m_serviceRequest.getService(), message), ILog.Level.TRACE);
        }
    }

    public String getLogId() {
        if (this.id == null) {
            this.id = String.format("(%s)", ServiceLog.toId(System.nanoTime()));
        }
        return this.id;
    }

    public static String toId(long i) {
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'A', 'b', 'B', 'c', 'C', 'd', 'D', 'e', 'E', 'f', 'F', 'g', 'G', 'h', 'H', 'i', 'j', 'J', 'k', 'K', 'L', 'm', 'M', 'n', 'N', 'o', 'p', 'P', 'q', 'Q', 'r', 'R', 's', 'S', 't', 'T', 'u', 'U', 'v', 'V', 'w', 'W', 'x', 'X', 'y', 'Y', 'z', 'Z'};
        long value = i;
        if (value == 0L) {
            return "0";
        }
        String result = "";
        while (value > 0L) {
            long mod;
            if ((value -= (mod = value % (long)digits.length)) > 0L) {
                value /= (long)digits.length;
            }
            result = digits[(int)mod] + result;
        }
        if (result.length() > 3) {
            result = result.substring(0, result.length() - 3) + "." + result.substring(result.length() - 3);
        }
        return result;
    }

    public static TimerProvider getTimerProvider() {
        if (s_timerProvider == null) {
            try {
                s_timerProvider = (TimerProvider)Class.forName("oracle.stellent.ridc.common.log.adf.AdfTimerProvider").newInstance();
            }
            catch (Throwable t) {
                s_timerProvider = new SimpleTimerProvider();
            }
        }
        return s_timerProvider;
    }
}

