/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class StreamUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream, boolean closeInput, boolean closeOutput) throws IOException {
        try {
            byte[] buffer = new byte[512];
            int read = 0;
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
        }
        finally {
            if (closeInput) {
                StreamUtil.closeStream(inputStream);
            }
            if (closeOutput) {
                StreamUtil.closeStream(outputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyReader(Reader reader, Writer writer, boolean closeInput, boolean closeOutput) throws IOException {
        try {
            char[] buffer = new char[512];
            int read = 0;
            while ((read = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, read);
            }
        }
        finally {
            if (closeInput) {
                StreamUtil.closeReader(reader);
            }
            if (closeOutput) {
                StreamUtil.closeWriter(writer);
            }
        }
    }

    public static void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getStringFromFile(File file) throws IOException {
        return StreamUtil.getStringFromFile(file, System.getProperty("file.encoding"));
    }

    public static String getStringFromFile(File file, String encoding) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Unable to read file: " + file);
        }
        return StreamUtil.getStringFromStream(new FileInputStream(file), encoding);
    }

    public static String getStringFromStream(InputStream stream) throws IOException {
        return StreamUtil.getStringFromStream(stream, System.getProperty("file.encoding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromStream(InputStream stream, String encoding) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (stream != null) {
            InputStreamReader reader = new InputStreamReader(stream, encoding);
            try {
                char[] buf = new char[512];
                int read = 0;
                while ((read = reader.read(buf)) != -1) {
                    sb.append(buf, 0, read);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException exp) {}
                }
            }
        }
        return sb.toString();
    }

    public static byte[] readRawLine(InputStream inputStream) throws IOException {
        int ch;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((ch = inputStream.read()) >= 0) {
            buf.write(ch);
            if (ch != 10) continue;
        }
        if (buf.size() == 0) {
            return null;
        }
        return buf.toByteArray();
    }

    public static String readLine(InputStream inputStream, String charset) throws IOException {
        byte[] rawdata = StreamUtil.readRawLine(inputStream);
        if (rawdata == null) {
            return null;
        }
        return new String(rawdata, charset);
    }

    public static byte[] tryRead(InputStream inputStream, int length) throws IOException {
        int read;
        int count;
        byte[] buf = new byte[length];
        int offset = 0;
        for (read = 0; read < length && (count = inputStream.read(buf, offset + read, length - read)) >= 0; read += count) {
        }
        if (read == length) {
            return buf;
        }
        byte[] subset = new byte[read];
        System.arraycopy(buf, 0, subset, 0, read);
        return subset;
    }
}

