/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTools {
    public static final String BOOLEAN_ON = "on";
    public static final String BOOLEAN_OFF = "off";
    public static final String BOOLEAN_YES = "yes";
    public static final String BOOLEAN_NO = "no";
    public static final String BOOLEAN_FALSE = "false";
    public static final String BOOLEAN_TRUE = "true";
    public static final String STR_COMMA = ",";
    public static final String STR_SEMICOLON = ";";
    public static final String STR_QUESTION = "?";
    public static final String STR_EQUALS = "=";
    public static final String STR_AND = "&";
    public static final String STR_SPACE = " ";
    public static final char CHR_DOT = '.';
    public static final char CHR_FORWARD_SLASH = '/';
    public static final char CHR_BACK_SLASH = '\\';
    public static final char CHR_TAB = '\t';
    static final String STR_FORMAT_CHARS = "\n\t";

    public static List<String> getListFromDelimitedString(String data, String delimiter) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(data, delimiter);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static int[] getIntArrayFromDelimitedString(String data, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(data, delimiter);
        int[] result = new int[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            result[i++] = Integer.parseInt(tokenizer.nextToken());
        }
        return result;
    }

    public static String[] getArrayFromCsvString(String csv) {
        if (StringTools.isEmpty(csv)) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(csv, STR_COMMA);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public static List<String> getListFromCsv(String value) {
        if (value == null) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, STR_COMMA);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static List<Long> getLongsListFromCsv(String value) {
        LinkedList<Long> list = new LinkedList<Long>();
        StringTokenizer tokenizer = new StringTokenizer(value, STR_COMMA);
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            list.add(Long.valueOf(token));
        }
        return list;
    }

    public static String getCsvFromCollection(Collection collection) {
        if (collection == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Object value = null;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            value = it.next();
            buffer.append(value.toString());
            if (!it.hasNext()) continue;
            buffer.append(STR_COMMA);
        }
        return buffer.toString();
    }

    public static String getFirstSegment(String value, String separator) {
        if (value == null) {
            return null;
        }
        int pos = value.indexOf(separator);
        return pos > 0 ? value.substring(0, pos) : null;
    }

    public static String getLastSegment(String value, String separator) {
        return StringTools.getLastSegment(value, separator, true);
    }

    public static String getLastSegment(String value, String separator, boolean includeSeparator) {
        if (value == null) {
            return null;
        }
        int pos = value.lastIndexOf(separator);
        if (includeSeparator) {
            return pos > 0 ? value.substring(pos) : null;
        }
        return pos > 0 ? value.substring(pos + 1) : null;
    }

    public static String getSegment(String str, String separator, int segment) {
        if (str == null || separator == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, separator);
        if (st.countTokens() < segment) {
            return null;
        }
        String segmentToken = null;
        int i = 0;
        do {
            segmentToken = st.nextToken();
        } while (i++ < segment && st.hasMoreTokens());
        return segmentToken;
    }

    public static String stripFirstSegment(String value, String separator) {
        if (value == null) {
            return null;
        }
        int pos = value.indexOf(separator);
        return pos >= 0 ? value.substring(pos + separator.length()) : value;
    }

    public static String stripLastSegment(String value, String separator) {
        if (value == null) {
            return null;
        }
        int pos = value.lastIndexOf(separator);
        return pos >= 0 ? value.substring(0, pos) : value;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(CharSequence sequence) {
        if (sequence == null) {
            return true;
        }
        return ((Object)sequence).toString().trim().length() == 0;
    }

    public static boolean isEmpty(char[] array) {
        if (array == null) {
            return true;
        }
        int len = Array.getLength(array);
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (Array.get(array, i) == null) continue;
            return false;
        }
        return true;
    }

    public static String change(String input, String oldPattern, String newPattern) {
        if (input == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(input.length());
        int start = 0;
        while (start < input.length()) {
            int index = input.indexOf(oldPattern, start);
            if (index > -1) {
                sb.append(input.substring(start, index));
                sb.append(newPattern);
                start = index + oldPattern.length();
                continue;
            }
            sb.append(input.substring(start));
            start = input.length();
        }
        return sb.toString();
    }

    public static String replaceChars(String orig, String chars, char replace) {
        int origSize = orig.length();
        StringBuffer buffer = new StringBuffer(origSize);
        for (int index = 0; index < origSize; ++index) {
            char textChar = orig.charAt(index);
            if (chars.indexOf(textChar) >= 0) {
                buffer.append(replace);
                continue;
            }
            buffer.append(textChar);
        }
        return buffer.toString();
    }

    public static boolean toBoolean(String value) {
        if (value == null) {
            return false;
        }
        if (value.equalsIgnoreCase(BOOLEAN_ON)) {
            return true;
        }
        if (value.equalsIgnoreCase(BOOLEAN_OFF)) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        return (value = value.trim()).equals("1") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase(BOOLEAN_TRUE) || value.equalsIgnoreCase(BOOLEAN_YES) || value.equalsIgnoreCase(BOOLEAN_ON);
    }

    public static String wrap(String value, String prefix, String postfix) {
        if (value == null) {
            return value;
        }
        return prefix + value + postfix;
    }

    public static String wrapIfRequired(String value, String prefix, String postfix) {
        if (value == null) {
            return value;
        }
        if (!StringTools.isEmpty(prefix) && !value.startsWith(prefix)) {
            value = prefix + value;
        }
        if (!StringTools.isEmpty(postfix) && !value.endsWith(postfix)) {
            value = value + postfix;
        }
        return value;
    }

    public static String unwrap(String value, String prefix, String postfix) {
        if (value == null) {
            return null;
        }
        if (!value.startsWith(prefix) || !value.endsWith(postfix)) {
            return null;
        }
        int lastIndex = value.lastIndexOf(postfix);
        return value.substring(prefix.length(), lastIndex);
    }

    public static String toCsv(List<String> strings) {
        StringBuffer buffer = new StringBuffer();
        String value = null;
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            value = iterator.next();
            buffer.append((Object)value);
            if (!iterator.hasNext()) continue;
            buffer.append(STR_COMMA);
        }
        return buffer.toString();
    }

    public static String toCsv(Object[] objects) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < objects.length; ++i) {
            sb.append(objects[i]);
            if (i >= objects.length - 1) continue;
            sb.append(STR_COMMA);
        }
        return sb.toString();
    }

    public static List<String> getDelimitedList(String value, String delims) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringTools.isEmpty(value)) {
            return result;
        }
        if (StringTools.isEmpty(delims)) {
            result.add(value);
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, delims);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static String replaceParams(String source, String[] params) {
        String result = source;
        for (int i = params.length - 1; i >= 0; --i) {
            String param = params[i];
            result = StringTools.change(result, "{" + i + "}", param);
        }
        return result;
    }

    public static String concat(String s1, String s2) {
        StringBuffer strBuffer = new StringBuffer(s1.length() + s2.length());
        strBuffer.append(s1).append(s2);
        return strBuffer.toString();
    }

    public static String evaluateRegexWithCallback(String text, String regEx, RegexAppendCallback callback) {
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (callback == null) continue;
            callback.appendReplacement(matcher, sb);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getValueOrDefault(String value, String defaultValue) {
        if (StringTools.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public static interface RegexAppendCallback {
        public void appendReplacement(Matcher var1, StringBuffer var2);
    }
}

