/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    protected static final String AMP_REF = "&amp;";
    protected static final String APOS_REF = "&apos;";
    protected static final String GT_REF = "&gt;";
    protected static final String LT_REF = "&lt;";
    protected static final String QUOT_REF = "&quot;";
    protected static final String CHAR_REF_START = "&#";

    public static Map<String, String> getAttributes(Element element) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            attributes.put(attr.getName(), attr.getValue());
        }
        return attributes;
    }

    public static int getAttributeAsInt(Element element, String name, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(element.getAttribute(name));
        }
        catch (Exception exp) {
            // empty catch block
        }
        return value;
    }

    public static long getAttributeAsLong(Element element, String name, long defaultValue) {
        long value = defaultValue;
        try {
            value = Long.parseLong(element.getAttribute(name));
        }
        catch (Exception exp) {
            // empty catch block
        }
        return value;
    }

    public static String toString(Node rootNode) throws TransformerException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLHelper.serialize(rootNode, bout);
        return bout.toString();
    }

    public static String encodeXml(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '&') {
                sb.append(AMP_REF);
                continue;
            }
            if (ch == '\'') {
                sb.append(APOS_REF);
                continue;
            }
            if (ch == '>') {
                sb.append(GT_REF);
                continue;
            }
            if (ch == '<') {
                sb.append(LT_REF);
                continue;
            }
            if (ch == '\"') {
                sb.append(QUOT_REF);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Document parseXML(InputStream xmlStream, boolean validating, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        return XMLHelper.parseXML(new InputSource(xmlStream), validating, namespaceAware);
    }

    public static Document parseXML(Reader xmlReader, boolean validating, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        return XMLHelper.parseXML(new InputSource(xmlReader), validating, namespaceAware);
    }

    public static Document parseXML(InputSource xmlSource, boolean validating, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        documentFactory.setValidating(validating);
        documentFactory.setNamespaceAware(namespaceAware);
        return documentFactory.newDocumentBuilder().parse(xmlSource);
    }

    public static void serialize(Node rootNode, OutputStream out) throws TransformerException {
        Transformer serializer = XMLHelper.createPrettyPrintTransformer();
        serializer.transform(new DOMSource(rootNode), new StreamResult(out));
    }

    public static void serialize(Node rootNode, Writer out) throws TransformerException {
        Transformer serializer = XMLHelper.createPrettyPrintTransformer();
        serializer.transform(new DOMSource(rootNode), new StreamResult(out));
    }

    public static Transformer createPrettyPrintTransformer() throws TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        tfactory.setAttribute("indent-number", 2);
        Transformer serializer = tfactory.newTransformer();
        serializer.setOutputProperty("method", "xml");
        serializer.setOutputProperty("indent", "yes");
        return serializer;
    }
}

