/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.xml;

import oracle.stellent.ridc.common.xml.XMLHelper;

public class XMLStringBuilder {
    public static void openCDataSection(StringBuffer sb) {
        sb.append("<![CDATA[");
    }

    public static void closeCDataSection(StringBuffer sb) {
        sb.append("]]>");
        sb.append("\r\n");
    }

    public static void addCDataSection(String cdata, StringBuffer sb) {
        XMLStringBuilder.openCDataSection(sb);
        sb.append(cdata);
        XMLStringBuilder.closeCDataSection(sb);
    }

    public static void addTextNode(String name, String text, boolean isCData, StringBuffer sb) {
        XMLStringBuilder.openTag(name, sb, false);
        if (isCData) {
            XMLStringBuilder.addCDataSection(text, sb);
        } else {
            sb.append(text);
        }
        XMLStringBuilder.closeTag(name, sb);
    }

    public static void addAttribute(String name, String value, StringBuffer sb, boolean finishTag) {
        if (value != null) {
            value = XMLHelper.encodeXml(value);
        }
        sb.append(" ");
        sb.append(name);
        sb.append("=\"");
        sb.append(value);
        sb.append("\"");
        if (finishTag) {
            sb.append(">");
        }
    }

    public static void openCloseTag(String name, StringBuffer sb) {
        sb.append("<");
        sb.append(name);
        sb.append("/>");
        sb.append("\r\n");
    }

    public static void openTag(String name, StringBuffer sb, boolean keepOpenForAttrs) {
        sb.append("<");
        sb.append(name);
        if (!keepOpenForAttrs) {
            sb.append(">");
        }
    }

    public static void closeTag(String name, StringBuffer sb) {
        sb.append("</");
        sb.append(name);
        sb.append(">");
        sb.append("\r\n");
    }
}

