/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.common.xml;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.stellent.ridc.common.xml.MapNamespaceContext;
import oracle.stellent.ridc.common.xml.XMLHelper;
import oracle.stellent.ridc.common.xml.XPathEvaluatorException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathEvaluator {
    protected NamespaceContext m_namespaceContext = null;
    protected Element m_documentRoot = null;
    protected XPath m_xpath = null;
    protected Node m_contextNode = null;
    protected String m_defaultPrefix = null;

    public XPathEvaluator(Element rootElement) {
        this.m_documentRoot = rootElement;
        this.m_contextNode = this.m_documentRoot;
        this.initNamespaceContext(null);
    }

    public XPathEvaluator(Element rootElement, NamespaceContext namespaceContext) {
        this.m_documentRoot = rootElement;
        this.m_contextNode = this.m_documentRoot;
        this.initNamespaceContext(namespaceContext);
    }

    public XPathEvaluator(InputStream xmlStream) throws XPathEvaluatorException {
        this(xmlStream, null, false, "wcm");
    }

    public XPathEvaluator(InputStream xmlStream, NamespaceContext namespaceContext, boolean validating, String defaultPrefix) throws XPathEvaluatorException {
        this(new InputSource(xmlStream), namespaceContext, validating, defaultPrefix);
    }

    public XPathEvaluator(Reader xmlReader) throws XPathEvaluatorException {
        this(xmlReader, null, false, "wcm");
    }

    public XPathEvaluator(Reader xmlReader, NamespaceContext namespaceContext, boolean validating, String defaultPrefix) throws XPathEvaluatorException {
        this(new InputSource(xmlReader), namespaceContext, validating, defaultPrefix);
    }

    public XPathEvaluator(InputSource xmlSource, NamespaceContext namespaceContext, boolean validating, String defaultPrefix) throws XPathEvaluatorException {
        try {
            Document document = XMLHelper.parseXML(xmlSource, validating, true);
            this.m_documentRoot = document.getDocumentElement();
            this.m_contextNode = document.getDocumentElement();
            this.m_defaultPrefix = defaultPrefix;
            this.initNamespaceContext(namespaceContext);
        }
        catch (Exception exp) {
            throw new XPathEvaluatorException(exp);
        }
    }

    protected void initNamespaceContext(NamespaceContext namespaceContext) {
        if (namespaceContext == null) {
            HashMap<String, String> namespaceMap = new HashMap<String, String>();
            NamedNodeMap nodeMap = this.m_documentRoot.getOwnerDocument().getDocumentElement().getAttributes();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Attr attribute = (Attr)nodeMap.item(i);
                String prefix = attribute.getPrefix();
                if ("xmlns".equals(prefix)) {
                    namespaceMap.put(attribute.getLocalName(), attribute.getValue());
                    continue;
                }
                if (!"xmlns".equals(attribute.getName()) || this.m_defaultPrefix == null) continue;
                namespaceMap.put(this.m_defaultPrefix, attribute.getValue());
            }
            namespaceContext = new MapNamespaceContext(namespaceMap);
        }
        this.m_namespaceContext = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.m_namespaceContext;
    }

    public void setIdAttribute(String attribute, boolean enable) {
        NodeList nodeList = this.evaluateToNodeList("//*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node currentNode = nodeList.item(i);
            if (!(currentNode instanceof Element) || !(element = (Element)currentNode).hasAttribute(attribute)) continue;
            element.setIdAttribute(attribute, enable);
        }
    }

    public Node getElementById(String id) {
        return this.getRootNode().getOwnerDocument().getElementById(id);
    }

    public void setContextNode(Node node) {
        this.m_contextNode = node;
    }

    public void setContextNode(String xpath) {
        XPathExpression xpathExpr = this.compileXPathExpression(xpath);
        try {
            Node node = (Node)xpathExpr.evaluate(this.getContextNode(), XPathConstants.NODE);
            if (node != null) {
                this.m_contextNode = node;
            }
        }
        catch (XPathExpressionException exp) {
            throw new XPathEvaluatorException(exp);
        }
    }

    public Node getContextNode() {
        return this.m_contextNode;
    }

    public Element getRootNode() {
        return this.m_documentRoot;
    }

    public void resetContext() {
        this.m_contextNode = this.getRootNode();
    }

    public String evaluateToString(String xpath) {
        return (String)this.evaluateXPath(xpath, XPathConstants.STRING);
    }

    public Node evaluateToNode(String xpath) {
        return (Node)this.evaluateXPath(xpath, XPathConstants.NODE);
    }

    public NodeList evaluateToNodeList(String xpath) {
        return (NodeList)this.evaluateXPath(xpath, XPathConstants.NODESET);
    }

    protected Object evaluateXPath(String xpath, QName returnType) {
        XPathExpression xpathExpr = this.compileXPathExpression(xpath);
        try {
            return xpathExpr.evaluate(this.getContextNode(), returnType);
        }
        catch (XPathExpressionException exp) {
            throw new XPathEvaluatorException(exp);
        }
    }

    protected XPathExpression compileXPathExpression(String xpath) throws XPathEvaluatorException {
        try {
            return this.getXPath().compile(xpath);
        }
        catch (XPathExpressionException exp) {
            throw new XPathEvaluatorException(exp);
        }
    }

    protected XPath getXPath() {
        if (this.m_xpath == null) {
            this.m_xpath = XPathFactory.newInstance().newXPath();
            if (this.m_namespaceContext != null) {
                this.m_xpath.setNamespaceContext(this.m_namespaceContext);
            }
        }
        return this.m_xpath;
    }
}

