/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.config.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcClientManager;
import oracle.stellent.ridc.common.util.StreamUtil;
import oracle.stellent.ridc.common.xml.XPathEvaluator;
import oracle.stellent.ridc.config.ConfigurationException;
import oracle.stellent.ridc.config.ConfigurationSerializer;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlConfigurationSerializer
implements ConfigurationSerializer<IdcClientConfig> {
    public static final String NAMESPACE_URI = "http://www.stellent.com/xml/idcclient";

    @Override
    public IdcClientManager readConfiguration(InputStream stream) throws ConfigurationException {
        IdcClientManager clientManager = new IdcClientManager();
        XPathEvaluator evaluator = new XPathEvaluator(stream, null, false, "idc");
        NodeList nodeList = evaluator.evaluateToNodeList("idc:config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            evaluator.setContextNode(element);
            clientManager.addClient(element.getAttribute("name"), this.readConfig(clientManager, evaluator));
        }
        return clientManager;
    }

    @Override
    public void serializeConfiguration(OutputStream stream, IdcClientManager clientManager) throws ConfigurationException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            writer.write(String.format("<%1$s xmlns=\"%2$s\"\r\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n", "clients", NAMESPACE_URI));
            for (String name : clientManager.getClientNames()) {
                this.writeConfig((IdcClientConfig)clientManager.getClient(name).getConfig(), name, writer);
            }
            writer.write(String.format("</%s>", "clients"));
            StreamUtil.closeWriter(writer);
        }
        catch (IOException exp) {
            throw new ConfigurationException(exp);
        }
    }

    protected void writeConfig(IdcClientConfig config, String name, Writer writer) throws IOException {
        writer.write(String.format("  <config name=\"%s\" url=\"%s\">\r\n", name, config.getConnectionString()));
        for (String propName : config.getPropertyNames()) {
            if ("url".equals(propName)) continue;
            String propValue = config.getProperty(propName);
            writer.write(String.format("    <property name=\"%s\" value=\"%s\" />\r\n", propName, propValue));
        }
        writer.write("  </config>\r\n");
    }

    protected IdcClient readConfig(IdcClientManager clientManager, XPathEvaluator evaluator) throws ConfigurationException {
        Element element = (Element)evaluator.getContextNode();
        String url = element.getAttribute("url");
        IdcClient client = null;
        try {
            client = clientManager.createClient(url);
        }
        catch (IdcClientException exp) {
            throw new ConfigurationException(RIDCMessages.config_unable_to_read_url(url), (Throwable)exp);
        }
        Object config = client.getConfig();
        NodeList propertyNodes = evaluator.evaluateToNodeList("idc:property");
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Element propElem = (Element)propertyNodes.item(i);
            String name = propElem.getAttribute("name");
            String value = propElem.getAttribute("value");
            ((IdcClientConfig)config).setProperty(name, value);
        }
        return client;
    }
}

