/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.adf.connection;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcClientManager;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.auth.CredentialsReference;
import oracle.stellent.ridc.auth.CredentialsType;
import oracle.stellent.ridc.auth.impl.AdfUserCredentials;
import oracle.stellent.ridc.auth.impl.AppIdClientCredentials;
import oracle.stellent.ridc.auth.impl.BasicCredentials;
import oracle.stellent.ridc.auth.impl.UserNameOnlyCredentials;
import oracle.stellent.ridc.convenience.adf.connection.RidcConnection;
import oracle.stellent.ridc.convenience.adf.connection.mxbean.RidcMxBeanManager;
import oracle.stellent.ridc.filter.IdcFilterType;
import oracle.stellent.ridc.i18n.locale.LocaleMessage;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;

public class AdfConnectionFacade {
    protected RidcMxBeanManager m_beanManager;
    protected String m_connectionName;
    protected IdcClientManager m_idcClientManager = new IdcClientManager();
    protected RidcConnection m_ridcConnection;
    protected IdcClient m_idcClient;

    public AdfConnectionFacade(String connectionName) {
        this.m_connectionName = connectionName;
    }

    public IdcClient getIdcClient() throws IdcClientException {
        if (this.m_idcClient != null) {
            return this.m_idcClient;
        }
        this.fetchConnection();
        this.m_idcClient = this.m_idcClientManager.createClient(this.m_ridcConnection.getConnectionUrl());
        for (Map.Entry<String, String> prop : this.m_ridcConnection.getConfigProperties().entrySet()) {
            ((IdcClientConfig)this.m_idcClient.getConfig()).setProperty(prop.getKey(), prop.getValue());
        }
        return this.m_idcClient;
    }

    public Credentials getUserCredentials(String credentialsLabel) throws IdcClientException {
        CredentialsType credentialsType;
        if (this.m_ridcConnection == null) {
            this.getIdcClient();
        }
        if ((credentialsType = this.getCredentialsType(credentialsLabel)) == null) {
            throw new IdcClientException(RIDCMessages.convenience_adf_credentials_label_not_found(credentialsLabel, this.m_connectionName));
        }
        Map<String, String> rows = this.getCredentialsFields(credentialsLabel);
        if (rows == null) {
            throw new IdcClientException(RIDCMessages.convenience_adf_credentials_entries_not_found(credentialsLabel, this.m_connectionName));
        }
        CredentialsReference credentialsReference = new CredentialsReference(null);
        credentialsReference.setProperties(rows);
        this.m_idcClientManager.getFilterManager().executeFilters(IdcFilterType.beforeAdfConnectionGetUserCredential, rows, credentialsReference);
        Credentials credentials = credentialsReference.getCredentials();
        if (credentials == null) {
            String name = rows.get("name");
            String password = rows.get("password");
            switch (credentialsType) {
                case nameonly: {
                    if ("<default>".equals(name)) {
                        credentials = new UserNameOnlyCredentials();
                        break;
                    }
                    credentials = new UserNameOnlyCredentials(name);
                    break;
                }
                case adf: {
                    credentials = new AdfUserCredentials();
                    break;
                }
                case basic: {
                    credentials = new BasicCredentials(name, password);
                    break;
                }
                case appid: {
                    credentials = new AppIdClientCredentials(name);
                }
            }
        }
        return credentials;
    }

    public ResultTestConnection testConnection(String credentialsLabel) {
        ResultTestConnection result = new ResultTestConnection();
        if (credentialsLabel == null) {
            result.setTestResults(false, RIDCMessages.convenience_adf_credentials_label_not_specified());
            return result;
        }
        String idcService = "<NONE>";
        try {
            IdcClient idcClient = this.getIdcClient();
            DataBinder dataBinder = idcClient.createBinder();
            Credentials credentials = this.getUserCredentials(credentialsLabel);
            CredentialsType credentialsType = CredentialsType.getCredentialsType(credentials);
            this.m_idcClientManager.getFilterManager().executeFilters(IdcFilterType.beforeAdfConnectionTestConnection, new Object[]{idcClient, credentials, credentialsType, result});
            if (!result.isTested()) {
                result.setTestResults(false, RIDCMessages.convenience_adf_connection_no_test_available(credentialsLabel));
                IdcContext idcContext = new IdcContext(credentials);
                DataBinder resultBinder = null;
                switch (credentialsType) {
                    case nameonly: {
                        idcService = "GET_SEARCH_RESULTS";
                        dataBinder.putLocal("IdcService", idcService);
                        dataBinder.putLocal("SortField", "dInDate");
                        dataBinder.putLocal("SortOrder", "Desc");
                        dataBinder.putLocal("ResultCount", "1");
                        dataBinder.putLocal("QueryText", "");
                        dataBinder.putLocal("SearchQueryFormat", "Universal");
                        resultBinder = this.m_idcClient.sendRequest(idcContext, dataBinder).getResponseAsBinder();
                        if (resultBinder != null) {
                            if (resultBinder.getResultSetNames().contains("SearchResults")) {
                                String duser = resultBinder.getLocal("dUser");
                                result.setTestResults(true, RIDCMessages.convenience_adf_connection_test_success(credentialsLabel, idcService, duser, ""));
                                break;
                            }
                            String statusMessage = resultBinder.getLocal("StatusMessage");
                            if (statusMessage == null) {
                                statusMessage = "";
                            }
                            result.setTestResults(true, RIDCMessages.convenience_adf_connection_test_failure(credentialsLabel, idcService, statusMessage));
                            break;
                        }
                        result.setTestResults(true, RIDCMessages.convenience_adf_connection_test_failure(credentialsLabel, idcService, ""));
                        break;
                    }
                    case adf: {
                        if (!((Credentials.AdfUserCredentials)idcContext.getCredentials()).isAuthenticated()) {
                            result.setTestResults(false, RIDCMessages.convenience_adf_connection_test_skipped(credentialsLabel));
                            break;
                        }
                    }
                    case basic: {
                        idcService = "PING_SERVER";
                        dataBinder.putLocal("IdcService", idcService);
                        resultBinder = this.m_idcClient.sendRequest(idcContext, dataBinder).getResponseAsBinder();
                        if (resultBinder != null) {
                            String status = resultBinder.getLocal("StatusMessage");
                            String duser = resultBinder.getLocal("dUser");
                            if (resultBinder.getResultSetNames().contains("UserAttribInfo") && status != null) {
                                result.setTestResults(true, RIDCMessages.convenience_adf_connection_test_success(credentialsLabel, idcService, duser, status));
                                break;
                            }
                            String statusMessage = resultBinder.getLocal("StatusMessage");
                            if (statusMessage == null) {
                                statusMessage = "";
                            }
                            result.setTestResults(true, RIDCMessages.convenience_adf_connection_test_failure(credentialsLabel, idcService, statusMessage));
                            break;
                        }
                        result.setTestResults(true, RIDCMessages.convenience_adf_connection_test_failure(credentialsLabel, idcService, ""));
                    }
                }
            }
        }
        catch (Exception e) {
            result.setTestResults(false, RIDCMessages.convenience_adf_connection_test_failure(credentialsLabel, idcService, e.getMessage()));
        }
        return result;
    }

    public Set<String> getCredentialsLabels() throws IdcClientException {
        if (this.m_ridcConnection == null) {
            this.fetchConnection();
        }
        TreeSet<String> result = new TreeSet<String>();
        for (String field : this.m_ridcConnection.getConfigProperties().keySet()) {
            CredentialsType credentialsType;
            String[] parts;
            if (field == null || field.length() <= 4 || (parts = field.split("\\.", 3)).length != 3 || (credentialsType = CredentialsType.getCredentialsType(parts[1])) == null) continue;
            result.add(parts[0]);
        }
        return result;
    }

    public RidcConnection getRidcConnection() throws IdcClientException {
        if (this.m_ridcConnection == null) {
            this.fetchConnection();
        }
        return this.m_ridcConnection;
    }

    protected void fetchConnection() throws IdcClientException {
        block6: {
            try {
                ADFContext adfContext = ADFContext.getCurrent();
                if (adfContext == null) {
                    throw new IdcClientException(RIDCMessages.convenience_adf_connection_adfcontext_not_found());
                }
                if (this.m_ridcConnection != null) break block6;
                try {
                    this.m_ridcConnection = (RidcConnection)adfContext.getConnectionsContext().lookup(this.m_connectionName);
                }
                catch (NamingException e) {
                    throw new IdcClientException(e);
                }
            }
            catch (NoClassDefFoundError e) {
                throw new IdcClientException(RIDCMessages.convenience_adf_connection_cannot_load_class("ADFContext"), (Throwable)e);
            }
        }
        if (this.m_ridcConnection == null) {
            throw new IdcClientException(RIDCMessages.convenience_adf_connection_name_not_found(this.m_connectionName));
        }
    }

    public CredentialsType getCredentialsType(String credentialsLabel) throws IdcClientException {
        if (this.m_ridcConnection == null) {
            this.fetchConnection();
        }
        CredentialsType result = null;
        for (String field : this.m_ridcConnection.getConfigProperties().keySet()) {
            CredentialsType credentialsType;
            String[] parts;
            if (field == null || field.length() <= 4 || (parts = field.split("\\.", 3)).length != 3 || !parts[0].equals(credentialsLabel) || (credentialsType = CredentialsType.getCredentialsType(parts[1])) == null) continue;
            result = credentialsType;
        }
        return result;
    }

    public Map<String, String> getCredentialsFields(String credentialsLabel) throws IdcClientException {
        CredentialsType credentialsType;
        if (this.m_ridcConnection == null) {
            this.fetchConnection();
        }
        if ((credentialsType = this.getCredentialsType(credentialsLabel)) == null) {
            throw new IdcClientException(RIDCMessages.convenience_adf_credentials_label_not_found(credentialsLabel, this.m_connectionName));
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, String> field : this.m_ridcConnection.getConfigProperties().entrySet()) {
            String[] parts;
            if (field == null || field.getKey().length() <= 4 || (parts = field.getKey().split("\\.", 3)).length != 3 || !parts[0].equals(credentialsLabel) || credentialsType != CredentialsType.getCredentialsType(parts[1])) continue;
            result.put(parts[2], field.getValue());
        }
        return result;
    }

    public void registerConnectionMBean() throws IdcClientException {
        try {
            this.m_beanManager = RidcMxBeanManager.getInstance(this.m_connectionName);
            this.m_beanManager.registerIfNotRegistered(this.m_connectionName);
        }
        catch (Exception e) {
            throw new IdcClientException(e);
        }
    }

    public void unregisterConnectionMBean() throws IdcClientException {
        try {
            this.m_beanManager.unregister(this.m_connectionName);
        }
        catch (Exception e) {
            throw new IdcClientException(e);
        }
    }

    public class ResultTestConnection {
        boolean m_tested = false;
        boolean m_success;
        LocaleMessage m_message;

        protected ResultTestConnection() {
        }

        public boolean isTested() {
            return this.m_tested;
        }

        public void setTestResults(boolean success, LocaleMessage message) {
            this.m_tested = true;
            this.m_success = success;
            this.m_message = message;
        }

        public boolean isSuccess() {
            return this.m_success;
        }

        public LocaleMessage getMessage() {
            return this.m_message;
        }
    }
}

