/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.adf.connection;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.stellent.ridc.auth.CredentialsType;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class RidcConnection
implements Referenceable {
    public static final String IDC_CONNECTION_KEY_PREFIX = "oracle.stellent.ridc.";
    public static final String CONNECTION_URL_KEY = "connectionUrl";
    private Map<String, String> properties = new HashMap<String, String>();
    private String connectionName;
    private boolean newConnection = true;

    public RidcConnection() {
    }

    public RidcConnection(String connectionName, Reference reference) {
        this(reference);
        this.connectionName = connectionName;
    }

    public RidcConnection(Reference ref) {
        this();
        if (ref != null) {
            this.newConnection = false;
            Enumeration<RefAddr> references = ref.getAll();
            while (references.hasMoreElements()) {
                String key;
                RefAddr refAddr = references.nextElement();
                if (!(refAddr instanceof StringRefAddr) && !(refAddr instanceof SecureRefAddr) || (key = this.getKey(refAddr)) == null) continue;
                String value = (String)refAddr.getContent();
                this.properties.put(key, value);
            }
        }
    }

    public static RidcConnection create(Reference ref, Name name, Context nameCtx, Hashtable<?, ?> environment) {
        RidcConnection c = new RidcConnection(ref);
        c.setConnectionName(name.toString());
        return c;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference("oracle.stellent.ridc.convenience.adf.connection.RidcConnection", "oracle.stellent.ridc.convenience.adf.connection.RidcConnectionFactory", null);
        for (String key : this.properties.keySet()) {
            if (key.toLowerCase().endsWith("password")) {
                this.addSecureReference(this.properties.get(key), key, ref);
                continue;
            }
            this.addReference(this.properties.get(key), key, ref);
        }
        return ref;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public boolean isNewConnection() {
        return this.newConnection;
    }

    public void setConfigParameters(Map<String, String> configParams) {
        this.properties.putAll(configParams);
    }

    public Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getConnectionUrl() {
        return this.getProperty(CONNECTION_URL_KEY);
    }

    public void setConnectionUrl(String connectionUrl) {
        this.setProperty(CONNECTION_URL_KEY, connectionUrl);
    }

    public int getSocketTimeout() {
        String socketTimeout = this.getProperty("socketTimeout");
        if (socketTimeout != null) {
            return Integer.parseInt(socketTimeout);
        }
        return 60000;
    }

    public void setSocketTimeout(int timeout) {
        this.setProperty("socketTimeout", String.valueOf(timeout));
    }

    public void setUserName(String credentialsLabel, CredentialsType credentialsType, String name) {
        this.setProperty(RidcConnection.getFieldNameForUserName(credentialsLabel, credentialsType), name);
    }

    public String getUserName(String credentialsLabel, CredentialsType credentialsType) {
        return this.getProperty(RidcConnection.getFieldNameForUserName(credentialsLabel, credentialsType));
    }

    public void setPassword(String credentialsLabel, CredentialsType credentialsType, String password) {
        this.setProperty(RidcConnection.getFieldNameForPassword(credentialsLabel, credentialsType), password);
    }

    public String getPassword(String credentialsLabel, CredentialsType credentialsType) {
        return this.getProperty(RidcConnection.getFieldNameForPassword(credentialsLabel, credentialsType));
    }

    public void setAppid(String credentialsLabel, CredentialsType credentialsType, String appid) {
        this.setProperty(RidcConnection.getFieldNameForAppid(credentialsLabel, credentialsType), appid);
    }

    public String getAppid(String credentialsLabel, CredentialsType credentialsType) {
        return this.getProperty(RidcConnection.getFieldNameForAppid(credentialsLabel, credentialsType));
    }

    public static String getFieldNameForUserName(String credentialsLabel, CredentialsType credentialsType) {
        RidcConnection.testCredential(credentialsType);
        return String.format("%s.%s.name", credentialsLabel, credentialsType.name());
    }

    public static String getFieldNameForPassword(String credentialsLabel, CredentialsType credentialsType) {
        RidcConnection.testCredential(credentialsType);
        return String.format("%s.%s.password", credentialsLabel, credentialsType.name());
    }

    public static String getFieldNameForAppid(String credentialsLabel, CredentialsType credentialsType) {
        RidcConnection.testCredential(credentialsType);
        return String.format("%s.%s.appid", credentialsLabel, credentialsType.name());
    }

    private static void testCredential(CredentialsType ct) {
        if (ct == null) {
            throw new IllegalArgumentException(RIDCMessages.convenience_adf_connection_credential_illegal_arguement_exception((Object)ct).toString());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(100);
        Formatter formatter = new Formatter(builder);
        formatter.format("IdcConnection[Name: %s, URL: %s, timeout: %s]", this.getConnectionName(), this.getConnectionUrl(), this.getSocketTimeout());
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RidcConnection)) {
            return false;
        }
        RidcConnection that = (RidcConnection)o;
        return !(this.properties != null ? !((Object)this.properties).equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        return this.properties != null ? ((Object)this.properties).hashCode() : 0;
    }

    private void addReference(Object obj, String name, Reference ref) {
        if (obj != null) {
            ref.add(new StringRefAddr(IDC_CONNECTION_KEY_PREFIX + name, obj.toString()));
        }
    }

    private void addSecureReference(Object obj, String name, Reference ref) {
        if (obj != null) {
            ref.add((RefAddr)new SecureRefAddr(IDC_CONNECTION_KEY_PREFIX + name, obj.toString()));
        }
    }

    private String getKey(RefAddr refAddr) {
        return refAddr.getType().substring(IDC_CONNECTION_KEY_PREFIX.length());
    }
}

