/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.adf.connection.mxbean;

import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.StandardEmitterMBean;
import javax.naming.Reference;
import oracle.stellent.ridc.convenience.adf.connection.RidcConnection;
import oracle.stellent.ridc.convenience.adf.connection.mxbean.RidcConnectionMxBean;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class RidcConnectionMxBeanImpl
extends StandardEmitterMBean
implements RidcConnectionMxBean {
    public static final String NOTIFY_TYPE_UPDATED = "oracle.stellent.ridc.connection.ridcconnection.type.updated";
    private long seqNumber;
    private RidcConnection connection;
    private String connectionName;

    public RidcConnectionMxBeanImpl(String connectionName, Reference reference) throws NotCompliantMBeanException {
        super(RidcConnectionMxBean.class, true, (NotificationEmitter)new NotificationBroadcasterSupport());
        this.connectionName = connectionName;
        this.connection = new RidcConnection(connectionName, reference);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public Reference getReference() throws Exception {
        return this.connection.getReference();
    }

    @Override
    public int getTimeout() {
        return this.connection.getSocketTimeout();
    }

    @Override
    public void setTimeout(int timeoutValue) {
        this.connection.setSocketTimeout(timeoutValue);
    }

    @Override
    public String getConnectionURL() {
        return this.connection.getConnectionUrl();
    }

    @Override
    public void setConnectionURL(String connectionURL) {
        this.connection.setConnectionUrl(connectionURL);
    }

    public String getConnectionType() {
        return "RIDC";
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public void setProperty(String key, String value) {
        this.connection.setProperty(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.connection.getProperty(key);
    }

    public RidcConnection getConnection() {
        return this.connection;
    }

    public void updateConnectionURL(String connectionURL) {
        this.connection.setProperty("connectionUrl", connectionURL);
        Notification notification = new Notification(NOTIFY_TYPE_UPDATED, (Object)this.connection, this.getNextSeqNumber(), RIDCMessages.convenience_adf_mbeans_url_updated().toString());
        this.sendNotification(notification);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{NOTIFY_TYPE_UPDATED}, Notification.class.getName(), RIDCMessages.convenience_adf_mbeans_user_creds_updated().toString())};
    }

    private synchronized long getNextSeqNumber() {
        return this.seqNumber++;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return RIDCMessages.convenience_adf_mbeans_description("RidcConnection").toString();
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("updateConnectionURL")) {
            switch (sequence) {
                case 0: {
                    return "connectionURL";
                }
            }
            return null;
        }
        if (op.getName().equals("setProperty")) {
            switch (sequence) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
            }
            return null;
        }
        if (op.getName().equals("getProperty")) {
            switch (sequence) {
                case 0: {
                    return "key";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("updateConnectionURL")) {
            switch (sequence) {
                case 0: {
                    return RIDCMessages.convenience_adf_mbeans_update_runtime_url_description(RIDCMessages.convenience_adf_mbeans_display_name().toString()).toString();
                }
            }
            return null;
        }
        if (op.getName().equals("setProperty")) {
            switch (sequence) {
                case 0: {
                    return RIDCMessages.convenience_adf_mbeans_set_property_key_description().toString();
                }
                case 1: {
                    return RIDCMessages.convenience_adf_mbeans_set_property_value_description().toString();
                }
            }
            return null;
        }
        if (op.getName().equals("getProperty")) {
            switch (sequence) {
                case 0: {
                    return RIDCMessages.convenience_adf_mbeans_get_property_key_description().toString();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        if (info.getName().equals("updateRuntimeURL")) {
            description = RIDCMessages.convenience_adf_mbeans_update_runtime_url_operation_description(RIDCMessages.convenience_adf_mbeans_display_name().toString()).toString();
        } else if (info.getName().equals("setProperty")) {
            description = RIDCMessages.convenience_adf_mbeans_set_property_operation_description().toString();
        } else if (info.getName().equals("getProperty")) {
            description = RIDCMessages.convenience_adf_mbeans_get_property_operation_description().toString();
        }
        return description;
    }
}

