/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.adf.connection.mxbean;

import java.lang.management.ManagementFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.convenience.adf.connection.RidcConnection;
import oracle.stellent.ridc.convenience.adf.connection.mxbean.RidcConnectionMxBeanImpl;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class RidcMxBeanManager
implements NotificationListener,
NotificationFilter {
    public static final String RIDC_MBEAN_OBJECT_TYPE = "oracle.stellent.ridc:type=RIDCConnection,name=%s";
    public static final MBeanServer MBEANS_SERVER;
    protected static final String CONNECTION_XML = "META-INF/connections.xml";
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private static final ILog log;
    private static volatile RidcMxBeanManager agent;
    private final String connectionName;
    private RidcConnection ridcConnection;
    private RidcConnectionMxBeanImpl mbean;
    private boolean updated;
    private Context connectionContext;

    private RidcMxBeanManager(String connectionName) throws NamingException {
        this.connectionName = connectionName;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RidcMxBeanManager getInstance(String connectionName) throws Exception {
        if (agent != null) return agent;
        Class<RidcMxBeanManager> clazz = RidcMxBeanManager.class;
        synchronized (RidcMxBeanManager.class) {
            if (agent != null) return agent;
            agent = new RidcMxBeanManager(connectionName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return agent;
        }
    }

    private void init() throws NamingException {
        try {
            this.connectionContext = this.getConnectionContext();
            if (this.connectionContext != null) {
                this.ridcConnection = (RidcConnection)this.connectionContext.lookup(this.connectionName);
                this.mbean = new RidcConnectionMxBeanImpl(this.connectionName, this.ridcConnection.getReference());
            }
        }
        catch (NotCompliantMBeanException ex) {
            log.log(RIDCMessages.convenience_adf_mbeans_manager_register_error(RIDCMessages.convenience_adf_mbeans_display_name().toString()), (Throwable)ex, ILog.Level.ERROR);
        }
        catch (NamingException ex) {
            log.log(RIDCMessages.convenience_adf_mbeans_manager_adf_connection_jndi_error(), (Throwable)ex, ILog.Level.ERROR);
            throw ex;
        }
    }

    public void register(String appId) throws Exception {
        this.mbean.addNotificationListener(this, this, this);
        MBEANS_SERVER.registerMBean(this.mbean, new ObjectName(String.format(RIDC_MBEAN_OBJECT_TYPE, appId)));
    }

    public void registerIfNotRegistered(String appId) throws Exception {
        this.mbean.addNotificationListener(this, this, this);
        ObjectName name = new ObjectName(String.format(RIDC_MBEAN_OBJECT_TYPE, appId));
        if (!MBEANS_SERVER.isRegistered(name)) {
            MBEANS_SERVER.registerMBean(this.mbean, name);
        }
    }

    public void unregister(String appId) throws Exception {
        this.mbean.removeNotificationListener(this);
        MBEANS_SERVER.unregisterMBean(new ObjectName(String.format(RIDC_MBEAN_OBJECT_TYPE, appId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if ("oracle.stellent.ridc.connection.ridcconnection.type.updated".equals(type) && this.connectionContext != null) {
            try {
                this.lock.writeLock().lock();
                this.ridcConnection = (RidcConnection)notification.getSource();
                this.updated = true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected Context getConnectionContext() throws NamingException {
        ADFContext context = ADFContext.getCurrent();
        return context == null ? null : context.getConnectionsContext();
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        String type = notification.getType();
        return "oracle.stellent.ridc.connection.ridcconnection.type.updated".equals(type);
    }

    public RidcConnection getRidcConnection() {
        return this.ridcConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdated() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.updated;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUpdated() {
        this.lock.writeLock().lock();
        try {
            this.updated = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static {
        log = LogFactory.getLog(RidcMxBeanManager.class);
        try {
            MBEANS_SERVER = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception ex) {
            log.log(RIDCMessages.convenience_adf_mbeans_manager_instance_error(), (Throwable)ex, ILog.Level.ERROR);
            Logger.getLogger(RidcMxBeanManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

