/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.adf.mbeans;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import oracle.adf.share.jndi.SecureRefAddr;

public class IdcConnection
implements Referenceable {
    public static final String IDC_CONNECTION_KEY_PREFIX = "oracle.stellent.idc.";
    public static final String RUNTIME_URL_KEY = "connectionUrl";
    public static final String DESIGNTIME_URL_KEY = "idcServerURL";
    private Map<String, String> properties = new HashMap<String, String>();
    private String connectionName;
    private boolean newConnection = true;

    public IdcConnection() {
    }

    public IdcConnection(String connectionName, Reference reference) {
        this(reference);
        this.connectionName = connectionName;
    }

    public IdcConnection(Reference ref) {
        this();
        if (ref != null) {
            this.newConnection = false;
            Enumeration<RefAddr> references = ref.getAll();
            while (references.hasMoreElements()) {
                String key;
                RefAddr refAddr = references.nextElement();
                if (!(refAddr instanceof StringRefAddr) && !(refAddr instanceof SecureRefAddr) || (key = this.getKey(refAddr)) == null) continue;
                String value = (String)refAddr.getContent();
                this.properties.put(key, value);
            }
        }
    }

    public static IdcConnection create(Reference ref, Name name, Context nameCtx, Hashtable<?, ?> environment) {
        IdcConnection c = new IdcConnection(ref);
        c.setConnectionName(name.toString());
        return c;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference("oracle.stellent.ridc.convenience.adf.mbeans.IdcConnection", "oracle.stellent.ridc.convenience.adf.mbeans.IdcConnectionFactory", null);
        for (String key : this.properties.keySet()) {
            if (key.toLowerCase().endsWith("password")) {
                this.addSecureReference(this.properties.get(key), key, ref);
                continue;
            }
            this.addReference(this.properties.get(key), key, ref);
        }
        return ref;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public boolean isNewConnection() {
        return this.newConnection;
    }

    public void setConfigParameters(Map<String, String> configParams) {
        this.properties.putAll(configParams);
    }

    public Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getConnectionUrl() {
        return this.getProperty(RUNTIME_URL_KEY);
    }

    public void setConnectionUrl(String connectionUrl) {
        this.setProperty(RUNTIME_URL_KEY, connectionUrl);
    }

    public int getSocketTimeout() {
        String socketTimeout = this.getProperty("socketTimeout");
        if (socketTimeout != null) {
            return Integer.parseInt(socketTimeout);
        }
        return 60000;
    }

    public void setSocketTimeout(int timeout) {
        this.setProperty("socketTimeout", String.valueOf(timeout));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(100);
        Formatter formatter = new Formatter(builder);
        formatter.format("IdcConnection[Name: %s, URL: %s, timeout: %s]", this.getConnectionName(), this.getConnectionUrl(), this.getSocketTimeout());
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdcConnection)) {
            return false;
        }
        IdcConnection that = (IdcConnection)o;
        return !(this.properties != null ? !((Object)this.properties).equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        return this.properties != null ? ((Object)this.properties).hashCode() : 0;
    }

    private void addReference(Object obj, String name, Reference ref) {
        if (obj != null) {
            ref.add(new StringRefAddr(IDC_CONNECTION_KEY_PREFIX + name, obj.toString()));
        }
    }

    private void addSecureReference(Object obj, String name, Reference ref) {
        if (obj != null) {
            ref.add((RefAddr)new SecureRefAddr(IDC_CONNECTION_KEY_PREFIX + name, obj.toString()));
        }
    }

    private String getKey(RefAddr refAddr) {
        return refAddr.getType().substring(IDC_CONNECTION_KEY_PREFIX.length());
    }
}

