/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.adf.mbeans;

import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.StandardEmitterMBean;
import javax.naming.Reference;
import oracle.stellent.ridc.convenience.adf.mbeans.IdcConnection;
import oracle.stellent.ridc.convenience.adf.mbeans.IdcConnectionMXBean;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class IdcConnectionMXBeanImpl
extends StandardEmitterMBean
implements IdcConnectionMXBean {
    public static final String NOTIF_TYPE_UPDATED = "oracle.stellent.ridc.mbean.ridcconnection.type.updated";
    private long seqNumber;
    private IdcConnection connection;
    private String connectionName;

    public IdcConnectionMXBeanImpl(String connectionName, Reference reference) throws NotCompliantMBeanException {
        super(IdcConnectionMXBean.class, true, (NotificationEmitter)new NotificationBroadcasterSupport());
        this.connectionName = connectionName;
        this.connection = new IdcConnection(connectionName, reference);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public Reference getReference() throws Exception {
        return this.connection.getReference();
    }

    @Override
    public int getTimeout() {
        return this.connection.getSocketTimeout();
    }

    @Override
    public void setTimeout(int timeoutValue) {
        this.connection.setSocketTimeout(timeoutValue);
    }

    @Override
    public String getKeystoreFile() {
        return this.connection.getProperty("sslKeystoreFile");
    }

    @Override
    public void setKeystoreFile(String keystoreFile) {
        this.connection.setProperty("sslKeystoreFile", keystoreFile);
    }

    @Override
    public void setKeystorePassword(String keystorePassword) {
        this.connection.setProperty("sslKeystorePassword", keystorePassword);
    }

    @Override
    public String getKeystoreAlias() {
        return this.connection.getProperty("sslKeystoreAlias");
    }

    @Override
    public void setKeystoreAlias(String keystoreAlias) {
        this.connection.setProperty("sslKeystoreAlias", keystoreAlias);
    }

    @Override
    public void setKeystoreAliasPassword(String keystoreAliasPassword) {
        this.connection.setProperty("sslKeystoreAliasPassword", keystoreAliasPassword);
    }

    @Override
    public String getDesigntimeURL() {
        return this.connection.getProperty("idcServerURL");
    }

    @Override
    public String getRuntimeURL() {
        return this.connection.getProperty("connectionUrl");
    }

    @Override
    public String getConnectionUrl() {
        return this.connection.getProperty("connectionUrl");
    }

    @Override
    public String getTrustManagerFile() {
        return this.connection.getProperty("sslTrustManagerFile");
    }

    @Override
    public void setTrustManagerFile(String trustManagerFile) {
        this.connection.setProperty("sslTrustManagerFile", trustManagerFile);
    }

    @Override
    public void setTrustManagerPassword(String trustManagerPassword) {
        this.connection.setProperty("sslTrustManagerPassword", trustManagerPassword);
    }

    @Override
    public String getClientSecurityPolicy() {
        return this.connection.getProperty("clientSecurityPolicy");
    }

    @Override
    public void setClientSecurityPolicy(String policy) {
        this.connection.setProperty("clientSecurityPolicy", policy);
    }

    @Override
    public String getCsfKey() {
        return this.connection.getProperty("csfKey");
    }

    @Override
    public void setCsfKey(String csfKey) {
        this.connection.setProperty("csfKey", csfKey);
    }

    public String getConnectionType() {
        return "IDC";
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public void setProperty(String key, String value) {
        this.connection.setProperty(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.connection.getProperty(key);
    }

    public IdcConnection getConnection() {
        return this.connection;
    }

    @Override
    public void updateRuntimeURL(String runtimeURL) {
        this.connection.setProperty("connectionUrl", runtimeURL);
        Notification notification = new Notification(NOTIF_TYPE_UPDATED, (Object)this.connection, this.getNextSeqNumber(), RIDCMessages.convenience_adf_mbeans_url_updated().toString());
        this.sendNotification(notification);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{NOTIF_TYPE_UPDATED}, Notification.class.getName(), RIDCMessages.convenience_adf_mbeans_user_creds_updated().toString())};
    }

    private synchronized long getNextSeqNumber() {
        return this.seqNumber++;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return RIDCMessages.convenience_adf_mbeans_description("IdcConnection").toString();
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("updateRuntimeURL")) {
            switch (sequence) {
                case 0: {
                    return "runtimeURL";
                }
            }
            return null;
        }
        if (op.getName().equals("setProperty")) {
            switch (sequence) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
            }
            return null;
        }
        if (op.getName().equals("getProperty")) {
            switch (sequence) {
                case 0: {
                    return "key";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("updateRuntimeURL")) {
            switch (sequence) {
                case 0: {
                    return RIDCMessages.convenience_adf_mbeans_update_runtime_url_description(RIDCMessages.ssxa_convenience_adf_mbeans_display_name().toString()).toString();
                }
            }
            return null;
        }
        if (op.getName().equals("setProperty")) {
            switch (sequence) {
                case 0: {
                    return RIDCMessages.convenience_adf_mbeans_set_property_key_description().toString();
                }
                case 1: {
                    return RIDCMessages.convenience_adf_mbeans_set_property_value_description().toString();
                }
            }
            return null;
        }
        if (op.getName().equals("getProperty")) {
            switch (sequence) {
                case 0: {
                    return RIDCMessages.convenience_adf_mbeans_get_property_key_description().toString();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        if (info.getName().equals("updateRuntimeURL")) {
            description = RIDCMessages.convenience_adf_mbeans_update_runtime_url_operation_description(RIDCMessages.ssxa_convenience_adf_mbeans_display_name().toString()).toString();
        } else if (info.getName().equals("setProperty")) {
            description = RIDCMessages.convenience_adf_mbeans_set_property_operation_description().toString();
        } else if (info.getName().equals("getProperty")) {
            description = RIDCMessages.convenience_adf_mbeans_get_property_operation_description().toString();
        }
        return description;
    }
}

