/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.adf.mbeans;

import java.lang.management.ManagementFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.convenience.adf.mbeans.IdcConnection;
import oracle.stellent.ridc.convenience.adf.mbeans.IdcConnectionMXBeanImpl;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class IdcMBeanManager
implements NotificationListener,
NotificationFilter {
    public static final String RIDC_MBEAN_OBJECT_TYPE = "oracle.stellent.ridc:type=IDCConnection,name=%s";
    public static final MBeanServer MBEANS_SERVER;
    protected static final String CONNECTION_XML = "META-INF/connections.xml";
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private static final ILog log;
    private static volatile IdcMBeanManager agent;
    private final String connectionName;
    private IdcConnection idcConnection;
    private IdcConnectionMXBeanImpl mbean;
    private boolean updated;
    private Context connectionContext;

    private IdcMBeanManager(String connectionName) throws NamingException {
        this.connectionName = connectionName;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IdcMBeanManager getInstance(String connectionName) throws Exception {
        if (agent != null) return agent;
        Class<IdcMBeanManager> clazz = IdcMBeanManager.class;
        synchronized (IdcMBeanManager.class) {
            if (agent != null) return agent;
            agent = new IdcMBeanManager(connectionName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return agent;
        }
    }

    private void init() throws NamingException {
        try {
            this.connectionContext = this.getConnectionContext();
            if (this.connectionContext != null) {
                this.idcConnection = (IdcConnection)this.connectionContext.lookup(this.connectionName);
                this.mbean = new IdcConnectionMXBeanImpl(this.connectionName, this.idcConnection.getReference());
            }
        }
        catch (NotCompliantMBeanException ex) {
            log.log(RIDCMessages.convenience_adf_mbeans_manager_register_error(RIDCMessages.ssxa_convenience_adf_mbeans_display_name()), (Throwable)ex, ILog.Level.ERROR);
        }
        catch (NamingException ex) {
            log.log(RIDCMessages.convenience_adf_mbeans_manager_adf_connection_jndi_error(), (Throwable)ex, ILog.Level.ERROR);
            throw ex;
        }
    }

    public void register(String appId) throws Exception {
        this.mbean.addNotificationListener(this, this, this);
        MBEANS_SERVER.registerMBean(this.mbean, new ObjectName(String.format(RIDC_MBEAN_OBJECT_TYPE, appId)));
    }

    public void registerIfNotRegistered(String appId) throws Exception {
        this.mbean.addNotificationListener(this, this, this);
        ObjectName name = new ObjectName(String.format(RIDC_MBEAN_OBJECT_TYPE, appId));
        if (!MBEANS_SERVER.isRegistered(name)) {
            MBEANS_SERVER.registerMBean(this.mbean, name);
        }
    }

    public void unregister(String appId) throws Exception {
        this.mbean.removeNotificationListener(this);
        MBEANS_SERVER.unregisterMBean(new ObjectName(String.format(RIDC_MBEAN_OBJECT_TYPE, appId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if ("oracle.stellent.ridc.mbean.ridcconnection.type.updated".equals(type) && this.connectionContext != null) {
            try {
                this.lock.writeLock().lock();
                this.idcConnection = (IdcConnection)notification.getSource();
                this.updated = true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected Context getConnectionContext() throws NamingException {
        ADFContext context = ADFContext.getCurrent();
        return context == null ? null : context.getConnectionsContext();
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        String type = notification.getType();
        return "oracle.stellent.ridc.mbean.ridcconnection.type.updated".equals(type);
    }

    public IdcConnection getIdcConnection() {
        return this.idcConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdated() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.updated;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUpdated() {
        this.lock.writeLock().lock();
        try {
            this.updated = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static {
        log = LogFactory.getLog(IdcMBeanManager.class);
        try {
            MBEANS_SERVER = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception ex) {
            log.log(RIDCMessages.convenience_adf_mbeans_manager_instance_error(), (Throwable)ex, ILog.Level.ERROR);
            Logger.getLogger(IdcMBeanManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

