/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.monitor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.TimeZone;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;

public class ContentHistoryWatcher
extends Observable {
    public static final String LOAD_USER_LOCALIZATION = "LOAD_USER_LOCALIZATION";
    public static final String GET_DATA_RESULTSET = "GET_DATARESULTSET";
    public static final String ACTION = "dAction";
    public static final String ACTION_DATE = "dActionDate";
    public static final String ACTION_MILLIS = "dActionMillis";
    public static final String DATA_SOURCE = "dataSource";
    public static final String RESULT_NAME = "resultName";
    public static final String WHERE_CLAUSE = "whereClause";
    public static final String ORDER_CLAUSE = "orderClause";
    public static final String MONITORED_SUBJECTS = "monitoredSubjects";
    public static final String REFRESH_SUBJECTS = "refreshSubjects";
    public static final String DOCUMENT_HISTORY = "DocHistory";
    protected ILog m_log = LogFactory.getLog(this.getClass());
    protected static final Long TIME_ZERO = 0L;
    protected static final Long TIME_EXPIRED = -1L;
    private long m_sleep = 60000L;
    private IdcPollingThread m_pollingThread = null;
    private final Map<String, Long> m_subjectTime = new HashMap<String, Long>();
    private DateFormat m_odbcDateFormat = null;
    protected IdcClient m_idcClient = null;
    protected IdcContext m_context = null;

    public ContentHistoryWatcher(IdcClient idcClient, IdcContext context) {
        this.m_idcClient = idcClient;
        this.m_context = context;
    }

    public long getSleep() {
        return this.m_sleep;
    }

    public void setSleep(long sleep) {
        this.m_sleep = sleep;
    }

    public IdcClient getIdcClient() {
        return this.m_idcClient;
    }

    public DateFormat getOdbcDateFormat() throws IdcClientException {
        if (this.m_odbcDateFormat == null) {
            this.m_odbcDateFormat = this.initializeDateFormat(this.getContext());
        }
        return this.m_odbcDateFormat;
    }

    public void stop() throws Exception {
        if (this.m_log.isLogEnabled(ILog.Level.DEBUG)) {
            this.m_log.log(String.format("Content cache event monitor shutting down polling thread for connection '%s'", ((IdcClientConfig)this.getIdcClient().getConfig()).getConnectionString()), ILog.Level.DEBUG);
        }
        if (this.m_pollingThread != null && this.m_pollingThread.isAlive()) {
            this.m_pollingThread.setKeepRunning(false);
            this.m_pollingThread.interrupt();
            this.m_pollingThread = null;
        }
    }

    public void start() {
        this.m_pollingThread = new IdcPollingThread();
        this.m_pollingThread.setName("RIDC Watcher [" + ((IdcClientConfig)this.getIdcClient().getConfig()).getConnectionString() + "]");
        this.m_pollingThread.setPriority(4);
        this.m_pollingThread.setDaemon(true);
        this.m_pollingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuerySubject(String subject) {
        Map<String, Long> map = this.m_subjectTime;
        synchronized (map) {
            this.m_subjectTime.put(subject, TIME_ZERO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuerySubjects(List subjects) {
        Map<String, Long> map = this.m_subjectTime;
        synchronized (map) {
            for (String subject : subjects) {
                this.addQuerySubject(subject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSubject(String name, long time) {
        Map<String, Long> map = this.m_subjectTime;
        synchronized (map) {
            this.m_subjectTime.put(name, new Long(time));
        }
    }

    protected DateFormat initializeDateFormat(IdcContext context) throws IdcClientException {
        IdcClient idcClient = this.getIdcClient();
        DataBinder binder = idcClient.createBinder();
        binder.putLocal("IdcService", LOAD_USER_LOCALIZATION);
        DataBinder responseBinder = idcClient.sendRequest(context, binder).getResponseAsBinder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String systemTimeZone = responseBinder.getLocal("SystemTimeZone");
        if (systemTimeZone != null) {
            dateFormat.setTimeZone(TimeZone.getTimeZone(systemTimeZone));
        }
        return dateFormat;
    }

    protected IdcContext getContext() {
        return this.m_context;
    }

    protected void fireContentUpdateEvent(DataObject contentInfo) {
        this.hasChanged();
        this.notifyObservers(contentInfo);
    }

    public void fireSubjectChangedEvent(String name, long time) {
    }

    public static class QueryDate {
        protected int m_id = 0;
        protected long m_date = 0L;

        public int getId() {
            return this.m_id;
        }

        public void setId(int id) {
            this.m_id = id;
        }

        public long getDate() {
            return this.m_date;
        }

        public void setDate(long date) {
            this.m_date = date;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryDate that = (QueryDate)o;
            if (this.m_id != that.m_id) {
                return false;
            }
            return this.m_date == that.m_date;
        }

        public int hashCode() {
            int result = this.m_id;
            result = 29 * result + (int)(this.m_date ^ this.m_date >>> 32);
            return result;
        }

        public String toString() {
            return "QueryDate: id = " + this.m_id + "; date = " + this.m_date;
        }
    }

    protected class IdcPollingThread
    extends Thread {
        protected boolean m_keepRunning = true;
        protected QueryDate m_currentDate = null;

        protected IdcPollingThread() {
        }

        public boolean isKeepRunning() {
            return this.m_keepRunning;
        }

        public void setKeepRunning(boolean keepRunning) {
            this.m_keepRunning = keepRunning;
        }

        @Override
        public void run() {
            if (ContentHistoryWatcher.this.m_log.isLogEnabled(ILog.Level.DEBUG)) {
                // empty if block
            }
            String[] whereClause = this.getCurrentDateWhereClause();
            boolean firstQuery = true;
            while (this.isKeepRunning()) {
                try {
                    DataBinder responseBinder;
                    DataBinder binder;
                    Thread.sleep(ContentHistoryWatcher.this.getSleep());
                    if (!this.isKeepRunning()) break;
                    IdcClient idcClient = ContentHistoryWatcher.this.getIdcClient();
                    if (firstQuery) {
                        DataResultSet docEvents;
                        binder = this.buildDocHistoryQuery(whereClause[0], whereClause[1]);
                        responseBinder = idcClient.sendRequest(ContentHistoryWatcher.this.getContext(), binder).getResponseAsBinder();
                        String refreshSubjects = responseBinder.getLocal(ContentHistoryWatcher.REFRESH_SUBJECTS);
                        if (!StringTools.isEmpty(refreshSubjects)) {
                            String[] items = refreshSubjects.split(",");
                            for (int i = 0; i < items.length; ++i) {
                                String name = items[i];
                                long value = Long.parseLong(items[++i]);
                                ContentHistoryWatcher.this.updateSubject(name, value);
                            }
                        }
                        if ((docEvents = responseBinder.getResultSet(ContentHistoryWatcher.DOCUMENT_HISTORY)) == null || docEvents.getRows().size() < 1) continue;
                        firstQuery = false;
                        whereClause = this.getCurrentDateWhereClause(docEvents.getRows().get(0));
                    }
                    binder = this.buildDocHistoryQuery(whereClause[0], whereClause[1]);
                    responseBinder = idcClient.sendRequest(ContentHistoryWatcher.this.getContext(), binder).getResponseAsBinder();
                    DataResultSet resultSet = responseBinder.getResultSet(ContentHistoryWatcher.DOCUMENT_HISTORY);
                    if (resultSet != null && !resultSet.getRows().isEmpty()) {
                        DataObject dataObject = resultSet.getRows().get(resultSet.getRows().size() - 1);
                        whereClause = this.getCurrentDateWhereClause(dataObject);
                    }
                    this.sendEventsForResponse(responseBinder);
                }
                catch (InterruptedException exp) {
                }
                catch (IdcClientException exp) {
                    this.setKeepRunning(false);
                }
                catch (Exception exception) {}
            }
        }

        protected DataBinder buildDocHistoryQuery(String whereClause, String orderClause) {
            DataBinder binder = ContentHistoryWatcher.this.getIdcClient().createBinder();
            binder.putLocal("IdcService", ContentHistoryWatcher.GET_DATA_RESULTSET);
            binder.putLocal(ContentHistoryWatcher.DATA_SOURCE, ContentHistoryWatcher.DOCUMENT_HISTORY);
            binder.putLocal(ContentHistoryWatcher.RESULT_NAME, ContentHistoryWatcher.DOCUMENT_HISTORY);
            binder.putLocal(ContentHistoryWatcher.WHERE_CLAUSE, whereClause);
            binder.putLocal(ContentHistoryWatcher.ORDER_CLAUSE, orderClause);
            binder.putLocal(ContentHistoryWatcher.MONITORED_SUBJECTS, this.getMonitoredSubjects(ContentHistoryWatcher.this.m_subjectTime));
            return binder;
        }

        protected void sendEventsForResponse(DataBinder responseBinder) {
            DataResultSet resultSet = responseBinder.getResultSet(ContentHistoryWatcher.DOCUMENT_HISTORY);
            for (DataObject row : resultSet.getRows()) {
                ContentHistoryWatcher.this.fireContentUpdateEvent(row);
            }
            String refreshSubjects = responseBinder.getLocal(ContentHistoryWatcher.REFRESH_SUBJECTS);
            if (!StringTools.isEmpty(refreshSubjects)) {
                String[] subjects = refreshSubjects.split(",");
                for (int i = 0; i < subjects.length; ++i) {
                    String name = subjects[i];
                    long time = Long.parseLong(subjects[++i]);
                    ContentHistoryWatcher.this.fireSubjectChangedEvent(name, time);
                }
            }
        }

        protected String getCurrentDate() {
            String retVal = null;
            QueryDate queryDate = this.m_currentDate;
            if (queryDate == null || queryDate.getDate() <= 0L) {
                retVal = this.getDefaultCurrentDate();
            } else {
                try {
                    String date = ContentHistoryWatcher.this.getOdbcDateFormat().format(new Date(queryDate.getDate()));
                    retVal = "{ ts '" + date + "'}";
                }
                catch (Exception e) {
                    retVal = this.getDefaultCurrentDate();
                }
            }
            return retVal;
        }

        protected String getDefaultCurrentDate() {
            return "(select max (dActionDate) from DocumentHistory)";
        }

        protected void updateCurrentDate(Date date) {
            this.m_currentDate = new QueryDate();
            this.m_currentDate.setDate(date.getTime());
        }

        protected String[] getCurrentDateWhereClause() {
            return new String[]{"dActionDate = " + this.getCurrentDate(), "order by dActionDate DESC, dActionMillis DESC"};
        }

        protected String[] getCurrentDateWhereClause(DataObject documentEvent) throws IdcClientException {
            Date actionDate = documentEvent.getDate(ContentHistoryWatcher.ACTION_DATE);
            String date = ContentHistoryWatcher.this.getOdbcDateFormat().format(actionDate);
            this.updateCurrentDate(actionDate);
            StringBuffer sb = new StringBuffer();
            sb.append("(").append(ContentHistoryWatcher.ACTION_DATE).append(" = ");
            sb.append("{ ts '").append(date).append("'}");
            sb.append(" AND ").append(ContentHistoryWatcher.ACTION_MILLIS).append(" > ");
            sb.append((String)documentEvent.get(ContentHistoryWatcher.ACTION_MILLIS));
            sb.append(")");
            sb.append(" or (").append(ContentHistoryWatcher.ACTION_DATE).append(" > ");
            sb.append("{ ts '").append(date).append("'}");
            sb.append(")");
            return new String[]{sb.toString(), "order by dActionDate ASC, dActionMillis ASC"};
        }

        protected String getMonitoredSubjects(Map<String, Long> subjectTime) {
            StringBuffer monitoredSubjects = new StringBuffer();
            Iterator<String> it = subjectTime.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                Long value = subjectTime.get(name);
                monitoredSubjects.append(name);
                monitoredSubjects.append(",");
                monitoredSubjects.append(value);
                if (!it.hasNext()) continue;
                monitoredSubjects.append(",");
            }
            return monitoredSubjects.toString();
        }
    }
}

