/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.convenience.usersecurity.IAccessResolver;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.convenience.usersecurity.impl.CSEnvCache;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.impl.DataResultSetRow;

public class AccessResolverAccounts
implements IAccessResolver {
    protected CSEnvCache m_csEnvCache = null;
    protected ILog m_log = LogFactory.getLog(this.getClass());

    public AccessResolverAccounts(CSEnvCache csEnvCache) {
        this.m_csEnvCache = csEnvCache;
    }

    @Override
    public Integer resolveAccessLevel(DataObject docInfo, DataBinder userBinder) {
        try {
            return this.resolveAccessLevel(docInfo, userBinder, null);
        }
        catch (IdcClientException e) {
            this.m_log.log(e.getMessage(), ILog.Level.ERROR);
            return null;
        }
    }

    @Override
    public Integer resolveAccessLevel(DataObject docInfo, DataBinder userBinder, ITrace trace) throws IdcClientException {
        Integer access = null;
        if (!this.m_csEnvCache.isUsingAccounts(trace)) {
            return null;
        }
        if (docInfo == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_dataobject_not_allowed());
        }
        if (userBinder == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_databinder_not_allowed());
        }
        String docAccount = (String)docInfo.get("dDocAccount");
        if (trace != null) {
            trace.addTraceStartSection(ITrace.Kind.account, String.format("resolveAccessLevel() in AccessResolverAccounts", new Object[0]));
        }
        Map<String, Integer> accountAccess = this.getUserAccountAccessLevels(userBinder.getResultSet("DocumentAccounts"));
        if (docAccount == null || docAccount.length() == 0) {
            access = accountAccess.get("#none");
            if (trace != null) {
                trace.addTrace(ITrace.Kind.account, String.format("userInfo: #none='%s'", access));
                trace.addTraceEndSection();
            }
            return access;
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.account, String.format("docInfo: dDocAccount='%s'", docAccount));
        }
        for (Map.Entry<String, Integer> acctKey : accountAccess.entrySet()) {
            String key = acctKey.getKey();
            if (!docAccount.startsWith(key)) continue;
            if (access == null) {
                if (trace != null) {
                    trace.addTrace(ITrace.Kind.account, String.format("userInfo: %s='%s'", acctKey.getKey(), acctKey.getValue()));
                }
                access = acctKey.getValue();
                continue;
            }
            if (trace != null) {
                trace.addTrace(ITrace.Kind.account, String.format("userInfo: %s='%s'", acctKey.getKey(), acctKey.getValue()));
            }
            access = access | acctKey.getValue();
        }
        if (access == null) {
            access = accountAccess.get("#all");
            if (trace != null) {
                trace.addTrace(ITrace.Kind.account, String.format("userInfo: #all='%s'", access));
            }
        }
        if (access == null) {
            if (trace != null) {
                trace.addTrace(ITrace.Kind.account, "userInfo: no access");
            }
            access = 0;
        }
        if (trace != null) {
            trace.addTraceEndSection();
        }
        return access;
    }

    @Override
    public void clearCache() {
        this.m_csEnvCache.clearCache();
    }

    private Map<String, Integer> getUserAccountAccessLevels(DataResultSet accounts) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<DataObject> aRows = accounts.getRows();
        for (int row = 0; row < aRows.size(); ++row) {
            DataResultSetRow acct = (DataResultSetRow)aRows.get(row);
            map.put(acct.get("dDocAccount"), Integer.parseInt(acct.get("privilege")));
        }
        return map;
    }
}

