/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.convenience.usersecurity.IAccessResolver;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.convenience.usersecurity.impl.AclListInfo;
import oracle.stellent.ridc.convenience.usersecurity.impl.AliasCache;
import oracle.stellent.ridc.convenience.usersecurity.impl.CSEnvCache;
import oracle.stellent.ridc.convenience.usersecurity.impl.CachedDataBinder;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.impl.DataFactoryImpl;
import oracle.stellent.ridc.model.serialize.HdaBinderSerializer;

public class AccessResolverAcl
implements IAccessResolver {
    protected CSEnvCache m_csEnvCache = null;
    protected AliasCache m_aliasCache = null;
    protected CachedDataBinder m_aliasBinder;
    protected IdcContext m_superuser;
    protected Map<String, Map<String, Integer>> m_attribMap = null;
    protected ILog m_log = LogFactory.getLog(this.getClass());

    public AccessResolverAcl(CSEnvCache csEnvCache, long timeToLive, IdcContext superuser) {
        this.m_csEnvCache = csEnvCache;
        this.m_aliasCache = new AliasCache(csEnvCache, timeToLive, superuser);
        this.m_superuser = superuser;
    }

    @Override
    public Integer resolveAccessLevel(DataObject docInfo, DataBinder userBinder) {
        try {
            return this.resolveAccessLevel(docInfo, userBinder, null);
        }
        catch (IdcClientException e) {
            this.m_log.log(e.getMessage(), ILog.Level.ERROR);
            return null;
        }
    }

    @Override
    public Integer resolveAccessLevel(DataObject docInfo, DataBinder userBinder, ITrace trace) throws IdcClientException {
        if (!this.m_csEnvCache.isUsingAcl(trace)) {
            return null;
        }
        if (docInfo == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_dataobject_not_allowed());
        }
        if (userBinder == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_databinder_not_allowed());
        }
        String user = this.m_csEnvCache.getServiceCallUtils().getUser(userBinder);
        if (user == null || user.length() < 1) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_username_cannot_be_null_or_empty());
        }
        if (trace != null) {
            trace.addTraceStartSection(ITrace.Kind.acl, String.format("resolveAccessLevel() in AccessResolverAcl", new Object[0]));
        }
        if (!this.m_csEnvCache.isInSpecialAuthGroups((String)docInfo.get("dSecurityGroup"), trace)) {
            if (trace != null) {
                trace.addTraceEndSection();
            }
            return null;
        }
        AclListInfo listInfo = new AclListInfo(this.m_csEnvCache, docInfo, trace);
        if (!listInfo.isAclListChecked(trace)) {
            if (trace != null) {
                trace.addTraceEndSection();
            }
            return null;
        }
        this.parseUserAttribInfo(userBinder, trace);
        Integer access = listInfo.getUserListAccess(user);
        if (trace != null) {
            trace.addTrace(ITrace.Kind.acl, String.format("User (&'%s') access = %s", user, access));
        }
        for (String aliasName : listInfo.getAliasNames()) {
            if (!this.m_aliasCache.isUserInAlias(user, aliasName)) continue;
            access = access | listInfo.getAliasListAccess(aliasName, trace);
        }
        for (String roleName : this.getUserRoles()) {
            access = access | listInfo.getRoleListAccess(roleName, trace);
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.acl, String.format("ACL access = %s", access));
            trace.addTraceEndSection();
        }
        return access;
    }

    @Override
    public void clearCache() {
        this.m_csEnvCache.clearCache();
        this.m_aliasCache.clearCache();
        this.m_aliasBinder = null;
    }

    private Set<String> getUserRoles() {
        Map<String, Integer> roleMap;
        Set<String> roles = new HashSet<String>();
        if (this.m_attribMap != null && (roleMap = this.m_attribMap.get("role")) != null) {
            roles = roleMap.keySet();
        }
        return roles;
    }

    private void parseUserAttribInfo(DataBinder userBinder, ITrace trace) throws IdcClientException {
        this.m_attribMap = new HashMap<String, Map<String, Integer>>();
        String user = this.m_csEnvCache.getServiceCallUtils().getUser(userBinder);
        if (user == null || user.length() < 1) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_username_cannot_be_null_or_empty());
        }
        DataResultSet userAttribs = userBinder.getResultSet("UserAttribInfo");
        if (userAttribs == null) {
            if (trace != null) {
                HdaBinderSerializer serializer = new HdaBinderSerializer("UTF-8", new DataFactoryImpl());
                String binder = "cannot get binder";
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    serializer.serializeBinder(bout, userBinder);
                    binder = bout.toString();
                }
                catch (IOException e) {
                    // empty catch block
                }
                trace.addTrace(ITrace.Kind.acl, String.format("UserAttribInfo resultset missing in binder\n%s", binder));
            }
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_userattribinfo_not_found());
        }
        for (DataObject row : userAttribs.getRows()) {
            if (!user.equals(row.get("dUserName"))) continue;
            String attribs = (String)row.get("AttributeInfo");
            if (attribs == null) {
                return;
            }
            int cnt = 0;
            String type = "";
            String name = "";
            String access = "";
            for (String token : attribs.split(",")) {
                switch (cnt) {
                    case 0: {
                        type = token;
                        break;
                    }
                    case 1: {
                        name = token;
                        break;
                    }
                    case 2: {
                        access = token;
                        if (!this.m_attribMap.containsKey(type)) {
                            this.m_attribMap.put(type, new HashMap());
                        }
                        Map<String, Integer> namedAccess = this.m_attribMap.get(type);
                        namedAccess.put(name, Integer.valueOf(access));
                    }
                }
                ++cnt;
                cnt %= 3;
            }
        }
    }
}

