/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.util.List;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.convenience.usersecurity.IAccessResolver;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.impl.DataResultSetRow;

public class AccessResolverSecurityGroups
implements IAccessResolver {
    protected ILog m_log = LogFactory.getLog(this.getClass());

    @Override
    public Integer resolveAccessLevel(DataObject docInfo, DataBinder userBinder) {
        try {
            return this.resolveAccessLevel(docInfo, userBinder, null);
        }
        catch (IdcClientException e) {
            this.m_log.log(e.getMessage(), ILog.Level.ERROR);
            return null;
        }
    }

    @Override
    public Integer resolveAccessLevel(DataObject docInfo, DataBinder userBinder, ITrace trace) throws IdcClientException {
        if (docInfo == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_dataobject_not_allowed());
        }
        if (userBinder == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_databinder_not_allowed());
        }
        int access = 0;
        if (trace != null) {
            trace.addTraceStartSection(ITrace.Kind.group, String.format("resolveAccessLevel() in AccessResolverSecurityGroups", new Object[0]));
        }
        String docSecurityGroup = (String)docInfo.get("dSecurityGroup");
        DataResultSet userSecurityGroups = userBinder.getResultSet("SecurityGroups");
        if (trace != null) {
            trace.addTrace(ITrace.Kind.group, String.format("docInfo: dSecurityGroup='%s'", docSecurityGroup));
        }
        if (docSecurityGroup != null && userSecurityGroups != null) {
            List<DataObject> sgRows = userSecurityGroups.getRows();
            for (int row = 0; row < sgRows.size(); ++row) {
                DataResultSetRow sg = (DataResultSetRow)sgRows.get(row);
                if (!sg.get("dGroupName").equals(docSecurityGroup)) continue;
                access = Integer.parseInt(sg.get("privilege"));
                if (trace == null) break;
                trace.addTrace(ITrace.Kind.group, String.format("userInfo: %s='%s'", docSecurityGroup, sg.get("privilege")));
                break;
            }
        }
        if (trace != null) {
            trace.addTraceEndSection();
        }
        return access;
    }

    @Override
    public void clearCache() {
    }
}

