/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.convenience.usersecurity.impl.CSEnvCache;
import oracle.stellent.ridc.model.DataObject;

public class AclListInfo {
    private CSEnvCache m_envCache = null;
    private String m_userList = null;
    private String m_aliasList = null;
    private String m_roleList = null;
    private boolean m_roleListInUse = false;

    public AclListInfo(CSEnvCache envCache, DataObject docInfo, ITrace trace) throws IdcClientException {
        this.m_envCache = envCache;
        this.m_userList = this.normalizeString((String)docInfo.get("xClbraUserList"));
        this.m_aliasList = this.normalizeString((String)docInfo.get("xClbraAliasList"));
        if (this.m_envCache.isUsingAclRoles(trace)) {
            this.m_roleList = this.normalizeString((String)docInfo.get("xClbraRoleList"));
            this.m_roleListInUse = true;
        }
    }

    public boolean isAclListChecked(ITrace trace) throws IdcClientException {
        boolean result = true;
        if (this.is11gDefault(trace) && this.m_userList == null && this.m_aliasList == null && (!this.m_roleListInUse || this.m_roleListInUse && this.m_roleList == null)) {
            result = false;
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.acl, String.format("isAclListChecked() = %s", result));
        }
        return result;
    }

    public int getUserListAccess(String username) {
        Integer access = this.getUserList().get(username);
        return access == null ? 0 : access;
    }

    public int getAliasListAccess(String aliasname, ITrace trace) {
        int result = 0;
        Integer access = this.getAliasList().get(aliasname);
        if (access != null && access != 0) {
            result = access;
            if (trace != null) {
                trace.addTrace(ITrace.Kind.acl, String.format("Alias (@'%s') access = %s", aliasname, result));
            }
            result = access;
        }
        return result;
    }

    public Set<String> getAliasNames() {
        return this.getAliasList().keySet();
    }

    public int getRoleListAccess(String rolename, ITrace trace) {
        int result = 0;
        Integer access = this.getRoleList().get(rolename);
        if (access != null && access != 0) {
            result = access;
            if (trace != null) {
                trace.addTrace(ITrace.Kind.acl, String.format("Role (:'%s') access = %s", rolename, result));
            }
        }
        return result;
    }

    private Map<String, Integer> getUserList() {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        if (this.m_userList != null) {
            for (String entry : this.m_userList.split(",")) {
                if (!entry.startsWith("&")) continue;
                list.put(this.getName(entry), AclListInfo.getAccessLevel(this, entry));
            }
        }
        return list;
    }

    private Map<String, Integer> getAliasList() {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        if (this.m_aliasList != null) {
            for (String entry : this.m_aliasList.split(",")) {
                if (!entry.startsWith("@")) continue;
                list.put(this.getName(entry), AclListInfo.getAccessLevel(this, entry));
            }
        }
        return list;
    }

    private Map<String, Integer> getRoleList() {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        if (this.m_roleList != null) {
            for (String entry : this.m_roleList.split(",")) {
                if (!entry.startsWith(":")) continue;
                list.put(this.getName(entry), AclListInfo.getAccessLevel(this, entry));
            }
        }
        return list;
    }

    private String getName(String entry) {
        int end = entry.indexOf("(");
        return entry.substring(1, end);
    }

    private String getPermissions(String entry) {
        int start = entry.indexOf("(");
        int end = entry.indexOf(")");
        return entry.substring(start + 1, end);
    }

    public static Integer getAccessLevel(AclListInfo aclListInfo, String entry) {
        Integer level = null;
        String access = aclListInfo.getPermissions(entry);
        if (access != null) {
            access = access.toUpperCase();
            level = 0;
            if (access.contains("R")) {
                level = level | 1;
            }
            if (access.contains("W")) {
                level = level | 2;
            }
            if (access.contains("D")) {
                level = level | 4;
            }
            if (access.contains("A")) {
                level = level | 8;
            }
        }
        return level;
    }

    private boolean is11gDefault(ITrace trace) throws IdcClientException {
        return this.m_envCache.isUsing11gDefaultAcl(trace);
    }

    private String normalizeString(String info) {
        String list = info;
        if (list != null && StringTools.isEmpty(list.trim())) {
            list = null;
        }
        return list;
    }
}

