/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.convenience.usersecurity.impl.CSEnvCache;
import oracle.stellent.ridc.convenience.usersecurity.impl.CachedDataBinder;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.impl.DataBinderImpl;

public class AliasCache {
    protected Map<String, List<String>> m_aliasMap = null;
    protected long m_timeToLive = 0L;
    protected IdcContext m_superuser = null;
    protected CachedDataBinder m_aliasesBinder = null;
    protected CSEnvCache m_csEnvCache = null;

    public AliasCache(CSEnvCache csEnvCache, long timeToLive, IdcContext superuser) {
        this.m_csEnvCache = csEnvCache;
        this.m_superuser = superuser;
        this.m_aliasMap = new HashMap<String, List<String>>();
        if (timeToLive > 0L) {
            this.m_timeToLive = timeToLive;
        }
    }

    public void clearCache() {
        this.m_aliasMap = null;
        this.m_aliasesBinder = null;
    }

    public boolean isUserInAlias(String userName, String aliasName) {
        try {
            return this.isUserInAlias(userName, aliasName, null);
        }
        catch (IdcClientException idcClientException) {
            return false;
        }
    }

    public boolean isUserInAlias(String userName, String aliasName, ITrace trace) throws IdcClientException {
        List<String> users;
        boolean isAlias = false;
        if (userName == null || aliasName == null) {
            return isAlias;
        }
        Map<String, List<String>> aliases = this.getAliasMap(trace);
        if (aliases.containsKey(aliasName) && (users = aliases.get(aliasName)) != null) {
            for (String user : users) {
                if (!userName.equals(user)) continue;
                isAlias = true;
                break;
            }
        }
        return isAlias;
    }

    private Map<String, List<String>> getAliasMap(ITrace trace) throws IdcClientException {
        if (this.m_aliasMap == null || this.m_aliasesBinder == null || this.m_aliasesBinder.hasExpired(this.m_timeToLive)) {
            DataResultSet aliasRS;
            DataBinder binder = this.getAliasesBinder(trace);
            this.m_aliasMap = new HashMap<String, List<String>>();
            if (binder != null && (aliasRS = binder.getResultSet("AliasUserMap")) != null) {
                for (DataObject row : aliasRS.getRows()) {
                    String alias = (String)row.get("dAlias");
                    String user = (String)row.get("dUserName");
                    List<String> aliasUserList = this.m_aliasMap.get(alias);
                    if (aliasUserList == null) {
                        aliasUserList = new ArrayList<String>();
                        this.m_aliasMap.put(alias, aliasUserList);
                    }
                    aliasUserList.add(user);
                }
            }
        }
        return this.m_aliasMap;
    }

    private DataBinder getAliasesBinder(ITrace trace) throws IdcClientException {
        DataBinder aliasesBinder = null;
        if (this.m_aliasesBinder == null || this.m_aliasesBinder.hasExpired(this.m_timeToLive)) {
            this.clearCache();
            this.m_aliasesBinder = this.m_csEnvCache.getServiceCallUtils().getAliasMap(this.m_csEnvCache.getIdcClient(), this.m_superuser, trace);
        }
        if (this.m_aliasesBinder != null) {
            aliasesBinder = this.m_aliasesBinder.getBinder();
        }
        if (aliasesBinder == null) {
            aliasesBinder = new DataBinderImpl();
        }
        return aliasesBinder;
    }
}

