/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.convenience.usersecurity.IServiceCallUtils;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.convenience.usersecurity.impl.CachedDataBinder;
import oracle.stellent.ridc.convenience.usersecurity.impl.ServiceCallUtils;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.impl.DataBinderImpl;

public class CSEnvCache {
    protected ILog m_log = LogFactory.getLog(this.getClass());
    protected IdcClient m_idcClient;
    protected IdcContext m_idcContext;
    protected CachedDataBinder m_serverEnvBinder;
    protected long m_timeToLive = 0L;
    protected Boolean m_usingAccounts = null;
    protected Boolean m_usingAcl = null;
    protected Boolean m_usingCollab = null;
    protected Boolean m_using11gDefaultAcl = null;
    protected Boolean m_usingAclRoles = null;
    protected Boolean m_usingOldRIDCAccessModel = null;
    protected Boolean m_usingAuthorDelete = null;
    protected String m_specialAuthGroups = null;
    protected IServiceCallUtils m_serviceCallUtils = null;

    @Deprecated
    public CSEnvCache(IdcClient idcClient, IdcContext idcContext, long timeToLive) {
        this(idcClient, idcContext, timeToLive, new ServiceCallUtils());
    }

    public CSEnvCache(IdcClient idcClient, IdcContext idcContext, long timeToLive, IServiceCallUtils serviceCallUtils) {
        this.m_idcClient = idcClient;
        if (idcContext == null && this.m_log.isLogEnabled(ILog.Level.WARN)) {
            this.m_log.log("isAuthorDelete detection requires an admin context", ILog.Level.WARN);
        }
        this.m_idcContext = idcContext;
        this.m_timeToLive = timeToLive;
        this.m_serviceCallUtils = serviceCallUtils;
    }

    public void clearCache() {
        this.m_serverEnvBinder = null;
        this.m_usingAccounts = null;
        this.m_usingAcl = null;
        this.m_usingCollab = null;
        this.m_using11gDefaultAcl = null;
        this.m_usingAclRoles = null;
        this.m_usingOldRIDCAccessModel = null;
        this.m_usingAuthorDelete = null;
        this.m_specialAuthGroups = null;
    }

    public IServiceCallUtils getServiceCallUtils() {
        return this.m_serviceCallUtils;
    }

    public boolean hasExpired(long timeToLive) {
        if (this.m_serverEnvBinder != null) {
            return this.m_serverEnvBinder.hasExpired(timeToLive);
        }
        return true;
    }

    public IdcClient getIdcClient() {
        return this.m_idcClient;
    }

    protected DataBinder getServerEnvironmentBinder(ITrace trace) throws IdcClientException {
        DataBinder serverenv = null;
        if (this.m_serverEnvBinder == null || this.m_serverEnvBinder.hasExpired(this.m_timeToLive)) {
            this.clearCache();
            IdcContext context = this.m_idcContext == null ? new IdcContext() : this.m_idcContext;
            this.m_serverEnvBinder = this.getServiceCallUtils().getServerEnvironment(this.m_idcClient, context, trace);
        }
        if (this.m_serverEnvBinder != null) {
            serverenv = this.m_serverEnvBinder.getBinder();
        }
        if (serverenv == null) {
            serverenv = new DataBinderImpl();
        }
        return serverenv;
    }

    public boolean isAuthorDeleteEnabled(ITrace trace) throws IdcClientException {
        if (this.m_usingAuthorDelete == null) {
            DataBinder env = this.getServerEnvironmentBinder(trace);
            String authorDelete = env.getLocal("AuthorDelete");
            this.m_usingAuthorDelete = authorDelete != null && (authorDelete.equals("1") || authorDelete.toLowerCase().startsWith("t")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.cache, String.format("isAuthorDeleteEnabled() = %s", this.m_usingAuthorDelete));
        }
        return this.m_usingAuthorDelete;
    }

    public boolean isUsingAccounts() {
        try {
            return this.isUsingAccounts(null);
        }
        catch (IdcClientException idcClientException) {
            return false;
        }
    }

    public boolean isUsingAccounts(ITrace trace) throws IdcClientException {
        if (this.m_usingAccounts == null) {
            DataBinder env = this.getServerEnvironmentBinder(trace);
            String useAccounts = env.getLocal("UseAccounts");
            if (useAccounts != null && trace != null) {
                trace.addTrace(ITrace.Kind.cache, String.format("UseAccounts=%s", useAccounts));
            }
            this.m_usingAccounts = useAccounts != null && (useAccounts.equals("1") || useAccounts.toLowerCase().startsWith("t")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.account, String.format("isUsingAccounts() = %s", this.m_usingAccounts));
        }
        return this.m_usingAccounts;
    }

    public boolean isUsingAcl() {
        try {
            return this.isUsingAcl(null);
        }
        catch (IdcClientException idcClientException) {
            return false;
        }
    }

    public boolean isUsingAcl(ITrace trace) throws IdcClientException {
        if (this.m_usingAcl == null) {
            DataBinder env = this.getServerEnvironmentBinder(trace);
            String useAcl = null;
            useAcl = env.getLocal("UseEntitySecurity");
            if (useAcl != null && trace != null) {
                trace.addTrace(ITrace.Kind.cache, String.format("UseEntitySecurity=%s", useAcl));
            }
            if (useAcl != null && (useAcl.equals("1") || useAcl.toLowerCase().startsWith("t"))) {
                this.m_usingAcl = true;
            }
            if (this.m_usingAcl == null || !this.m_usingAcl.booleanValue()) {
                this.m_usingAcl = this.isCollaborationModel(trace);
            }
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.acl, String.format("isUsingAcl() = %s", this.m_usingAcl));
        }
        return this.m_usingAcl;
    }

    public boolean isCollaborationModel() {
        try {
            return this.isCollaborationModel(null);
        }
        catch (IdcClientException idcClientException) {
            return false;
        }
    }

    public boolean isCollaborationModel(ITrace trace) throws IdcClientException {
        if (this.m_usingCollab == null) {
            DataBinder env = this.getServerEnvironmentBinder(trace);
            String collab = env.getLocal("UseCollaboration");
            if (collab != null && trace != null) {
                trace.addTrace(ITrace.Kind.cache, String.format("UseCollaboration=%s", collab));
            }
            this.m_usingCollab = collab != null && (collab.equals("1") || collab.toLowerCase().startsWith("t")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.acl, String.format("isCollaborationModel() = %s", this.m_usingCollab));
        }
        return this.m_usingCollab;
    }

    public boolean isUsingAclRoles() {
        try {
            return this.isUsingAclRoles(null);
        }
        catch (IdcClientException idcClientException) {
            return false;
        }
    }

    public boolean isUsingAclRoles(ITrace trace) throws IdcClientException {
        if (this.m_usingAclRoles == null) {
            this.m_usingAclRoles = false;
            DataBinder env = this.getServerEnvironmentBinder(trace);
            DataResultSet features = env.getResultSet("Features");
            for (DataObject row : features.getRows()) {
                String name = (String)row.get("idcFeatureName");
                if (!"RoleEntityACL".equalsIgnoreCase(name)) continue;
                if (trace != null) {
                    trace.addTrace(ITrace.Kind.cache, String.format("idcFeatureName=%s, idcFeatureVersion=%s, idcFeatureLevel=%s", row.get("idcFeatureName"), row.get("idcFeatureVersion"), row.get("idcFeatureLevel")));
                }
                this.m_usingAclRoles = true;
                break;
            }
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.acl, String.format("isUsingAclRoles() = %s", this.m_usingAclRoles));
        }
        return this.m_usingAclRoles;
    }

    public boolean isUsing11gDefaultAcl() {
        try {
            return this.isUsing11gDefaultAcl(null);
        }
        catch (IdcClientException idcClientException) {
            return false;
        }
    }

    public boolean isUsing11gDefaultAcl(ITrace trace) throws IdcClientException {
        if (this.m_using11gDefaultAcl == null) {
            DataBinder env = this.getServerEnvironmentBinder(trace);
            String ignoreIfEmpty = env.getLocal("AccessListPrivilegesGrantedWhenEmpty");
            if (ignoreIfEmpty != null && trace != null) {
                trace.addTrace(ITrace.Kind.cache, String.format("AccessListPrivilegesGrantedWhenEmpty=%s", ignoreIfEmpty));
            }
            this.m_using11gDefaultAcl = ignoreIfEmpty != null && (ignoreIfEmpty.equals("1") || ignoreIfEmpty.toLowerCase().startsWith("t")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (trace != null) {
            trace.addTrace(ITrace.Kind.acl, String.format("isUsing11gDefaultAcl() = %s", this.m_using11gDefaultAcl));
        }
        return this.m_using11gDefaultAcl;
    }

    public boolean isInSpecialAuthGroups(String dSecurityGroup) {
        try {
            return this.isInSpecialAuthGroups(dSecurityGroup, null);
        }
        catch (IdcClientException idcClientException) {
            return false;
        }
    }

    public boolean isInSpecialAuthGroups(String dSecurityGroup, ITrace trace) throws IdcClientException {
        boolean result = false;
        if (this.m_specialAuthGroups == null) {
            DataBinder env = this.getServerEnvironmentBinder(trace);
            this.m_specialAuthGroups = env.getLocal("SpecialAuthGroups");
            if (this.m_specialAuthGroups != null && trace != null) {
                trace.addTrace(ITrace.Kind.cache, String.format("SpecialAuthGroups=%s", this.m_specialAuthGroups));
            }
        }
        if (dSecurityGroup != null && !StringTools.isEmpty(dSecurityGroup)) {
            dSecurityGroup = dSecurityGroup.trim();
            if (this.m_specialAuthGroups != null && !StringTools.isEmpty(this.m_specialAuthGroups)) {
                for (String group : this.m_specialAuthGroups.split(",")) {
                    if (group == null || !dSecurityGroup.equalsIgnoreCase(group.trim())) continue;
                    result = true;
                    break;
                }
            }
        }
        if (trace != null && trace != null) {
            trace.addTrace(ITrace.Kind.acl, String.format("isInSpecialAuthGroups(%s) = %s", dSecurityGroup, result));
        }
        return result;
    }
}

