/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.util.List;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.convenience.usersecurity.IServiceCallUtils;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.convenience.usersecurity.impl.CachedDataBinder;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.protocol.ServiceResponse;

public class ServiceCallUtils
implements IServiceCallUtils {
    protected ILog m_log = LogFactory.getLog(this.getClass());

    @Override
    public String getUser(DataBinder binder) {
        String userId = null;
        if (!(binder == null || (userId = binder.getLocal("dUserName")) != null && userId.length() > 0 || (userId = binder.getLocal("dUser")) != null && userId.length() > 0)) {
            return null;
        }
        return userId;
    }

    @Override
    public DataResultSet getDocInfo(DataBinder docBinder) {
        return docBinder.getResultSet("DOC_INFO");
    }

    @Override
    public List<DataObject> getDocInfoRows(DataBinder docBinder) {
        return this.getDocInfo(docBinder).getRows();
    }

    @Override
    public CachedDataBinder getUserPermissions(IdcClient client, IdcContext userContext) {
        CachedDataBinder result = null;
        try {
            result = this.getUserPermissions(client, userContext, null);
        }
        catch (IdcClientException e) {
            this.m_log.log(e.getMessage(), ILog.Level.ERROR);
        }
        return result;
    }

    @Override
    public CachedDataBinder getUserPermissions(IdcClient client, IdcContext userContext, ITrace trace) throws IdcClientException {
        if (client == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_idcclient_not_allowed());
        }
        DataBinder dataBinder = client.createBinder();
        dataBinder.putLocal("IdcService", "GET_USER_PERMISSIONS");
        DataBinder result = null;
        try {
            ServiceResponse response = client.sendRequest(userContext, dataBinder);
            result = response.getResponseAsBinder();
        }
        catch (IdcClientException e) {
            String message = null;
            if (this.m_log.isLogEnabled(ILog.Level.DEBUG) || trace != null) {
                message = String.format("Service call %s for user '%s' reports error: %s", dataBinder.getLocal("IdcService"), userContext.getUser(), e.getMessage());
            }
            this.m_log.log(message, (Throwable)e, ILog.Level.DEBUG);
            if (trace != null) {
                trace.addTrace(ITrace.Kind.error, message);
            }
            throw e;
        }
        return new CachedDataBinder(result);
    }

    @Override
    public CachedDataBinder getServerEnvironment(IdcClient client, IdcContext userContext) {
        CachedDataBinder result = null;
        try {
            result = this.getServerEnvironment(client, userContext, null);
        }
        catch (IdcClientException e) {
            // empty catch block
        }
        return result;
    }

    @Override
    public CachedDataBinder getServerEnvironment(IdcClient client, IdcContext userContext, ITrace trace) throws IdcClientException {
        if (client == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_idcclient_not_allowed());
        }
        DataBinder dataBinder = client.createBinder();
        dataBinder.putLocal("IdcService", "GET_ENVIRONMENT");
        DataBinder result = null;
        try {
            ServiceResponse response = client.sendRequest(userContext, dataBinder);
            result = response.getResponseAsBinder();
        }
        catch (IdcClientException e) {
            String message = null;
            if (this.m_log.isLogEnabled(ILog.Level.DEBUG) || trace != null) {
                message = String.format("Service call %s for user '%s' reports error: %s", dataBinder.getLocal("IdcService"), userContext.getUser(), e.getMessage());
            }
            this.m_log.log(message, (Throwable)e, ILog.Level.DEBUG);
            if (trace != null) {
                trace.addTrace(ITrace.Kind.error, message);
            }
            throw e;
        }
        return new CachedDataBinder(result);
    }

    @Override
    public CachedDataBinder getAliasMap(IdcClient client, IdcContext superuser) {
        CachedDataBinder result = null;
        try {
            result = this.getAliasMap(client, superuser, null);
        }
        catch (IdcClientException e) {
            // empty catch block
        }
        return result;
    }

    @Override
    public CachedDataBinder getAliasMap(IdcClient client, IdcContext superuser, ITrace trace) throws IdcClientException {
        if (client == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_idcclient_not_allowed());
        }
        DataBinder dataBinder = client.createBinder();
        dataBinder.putLocal("IdcService", "GET_ALIASES");
        DataBinder result = null;
        try {
            ServiceResponse response = client.sendRequest(superuser, dataBinder);
            result = response.getResponseAsBinder();
        }
        catch (IdcClientException e) {
            String message = null;
            if (this.m_log.isLogEnabled(ILog.Level.DEBUG) || trace != null) {
                message = String.format("Service call %s for user '%s' reports error: %s", dataBinder.getLocal("IdcService"), superuser.getUser(), e.getMessage());
            }
            this.m_log.log(message, (Throwable)e, ILog.Level.DEBUG);
            if (trace != null) {
                trace.addTrace(ITrace.Kind.error, message);
            }
            throw e;
        }
        return new CachedDataBinder(result);
    }
}

