/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.CRC32;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.convenience.usersecurity.IUserSecurityCache;
import oracle.stellent.ridc.model.DataObject;

public class Trace
implements ITrace {
    protected List<String> m_trace = new ArrayList<String>();
    protected Stack<StackObject> m_stack = new Stack();
    protected final String m_spaces = "                                                                               ";

    @Override
    public void addTrace(ITrace.Kind kind, String message) {
        if (message != null) {
            int levels = this.m_stack.size();
            this.m_trace.add(String.format("%s |%s -%s", kind.getValue(), "                                                                               ".substring(0, levels), message));
        }
    }

    @Override
    public void addTraceStartSection(ITrace.Kind kind, String message) {
        int levels = 0;
        String result = "";
        this.m_stack.push(new StackObject(kind, String.format(message, new Object[0])));
        levels = this.m_stack.size();
        result = String.format("%s>%s", "                                                                               ".substring(0, levels), message);
        this.m_trace.add(String.format("%s |%s", kind.getValue(), result));
    }

    @Override
    public void addTraceEndSection(int access) {
        String result = "Trace Stack Corrupted";
        ITrace.Kind kind = ITrace.Kind.none;
        String accessString = Trace.getAccessString(access);
        int levels = this.m_stack.size();
        if (levels > 0) {
            StackObject stack = this.m_stack.pop();
            kind = stack.getKind();
            result = stack.getMessage();
        }
        this.m_trace.add(String.format("%s |%s<%s", accessString, "                                                                               ".substring(0, levels), result));
    }

    @Override
    public void addTraceEndSection(boolean isAdmin, IUserSecurityCache.AdminType type) {
        String result = "Trace Stack Corrupted";
        ITrace.Kind kind = ITrace.Kind.none;
        String adminFlags = Trace.getAdminString(isAdmin, type);
        int levels = this.m_stack.size();
        if (levels > 0) {
            StackObject stack = this.m_stack.pop();
            kind = stack.getKind();
            result = stack.getMessage();
        }
        this.m_trace.add(String.format("%s |%s<%s", adminFlags, "                                                                               ".substring(0, levels), result));
    }

    @Override
    public void addTraceEndSection() {
        this.addTraceEndSection(null);
    }

    public void addTraceEndSection(String message) {
        int levels = 0;
        String result = "";
        String stackmsg = "Trace Stack Corrupted";
        ITrace.Kind kind = ITrace.Kind.none;
        if (message == null) {
            levels = this.m_stack.size();
            if (levels > 0) {
                StackObject stack = this.m_stack.pop();
                kind = stack.getKind();
                stackmsg = stack.getMessage();
            }
        } else if (levels > 0) {
            this.m_stack.pop();
        }
        result = String.format("%s<%s", "                                                                               ".substring(0, levels), stackmsg);
        this.m_trace.add(String.format("%s |%s", kind.getValue(), result));
    }

    @Override
    public void clear() {
        this.m_trace.clear();
        this.m_stack.clear();
    }

    @Override
    public String formatTrace() {
        String result = "";
        int maxlen = 0;
        if (this.m_trace != null) {
            for (String line : this.m_trace) {
                maxlen = Math.max(maxlen, line.length());
            }
            char[] arr = new char[maxlen];
            Arrays.fill(arr, '*');
            String stars = new String(arr);
            Arrays.fill(arr, ' ');
            String blanks = new String(arr);
            result = String.format("\n**%s**\n", stars);
            for (String line : this.m_trace) {
                maxlen = Math.max(maxlen, line.length());
                result = result + String.format("* %s%s *\n", line, blanks.substring(line.length()));
            }
            result = result + String.format("**%s**\n\n", stars);
            this.clear();
        }
        return result;
    }

    public static String getDocTraceId(DataObject info) {
        String result = null;
        if (info != null) {
            result = (String)info.get("dCollectionPath");
            if (result == null || StringTools.isEmpty(result.trim())) {
                result = String.format("%s [%s]", info.get("dDocTitle"), info.get("dDocName"));
            }
            if (result == null) {
                String all = "";
                for (Map.Entry entry : info.entrySet()) {
                    all = all + String.format("%s=%s ", entry.getKey(), entry.getValue());
                }
                CRC32 checksum = new CRC32();
                checksum.update(all.getBytes());
                result = String.format("MOCKSUM %s", checksum.getValue());
            }
        }
        return result;
    }

    public static String getAccessString(int accessLevel) {
        switch (accessLevel) {
            case 0: {
                return "---";
            }
            case 1: {
                return "R--";
            }
            case 3: {
                return "RW-";
            }
            case 7: {
                return "RWD";
            }
            case 15: {
                return "RWDA";
            }
        }
        return "?";
    }

    public static String getAdminString(boolean isAdmin, IUserSecurityCache.AdminType type) {
        switch (type) {
            case GROUP: {
                return isAdmin ? "G.." : "...";
            }
            case ACCOUNT: {
                return isAdmin ? ".A." : "...";
            }
            case ACL: {
                return isAdmin ? "..L" : "...";
            }
        }
        return "?";
    }

    public static String getAccessString(String accessLevel) {
        String result = "";
        if (accessLevel != null) {
            try {
                result = Trace.getAccessString(Integer.parseInt(accessLevel));
            }
            catch (NumberFormatException nfe) {
                result = String.format("Error parsing '%s'", accessLevel);
            }
        }
        return result;
    }

    class StackObject {
        private ITrace.Kind m_kind;
        private String m_message;

        StackObject(ITrace.Kind kind, String message) {
            this.m_kind = kind;
            this.m_message = message;
        }

        ITrace.Kind getKind() {
            return this.m_kind;
        }

        String getMessage() {
            return this.m_message;
        }
    }
}

