/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.convenience.usersecurity.IUserSecurityFlags;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;

public class UserSecurityFlags
implements IUserSecurityFlags {
    private DataResultSet m_userSecurityResultSet = null;
    private Map<String, String> m_allFlags = null;
    private Map<String, Boolean> m_allFlagsAsBoolean = null;
    private Set<String> m_allTrueFlags = null;

    public UserSecurityFlags(DataResultSet userSecurityResultSet) {
        if (userSecurityResultSet == null) {
            throw new IllegalArgumentException(RIDCMessages.convenience_usersecurity_null_dataobject_not_allowed().toString());
        }
        this.m_userSecurityResultSet = userSecurityResultSet;
    }

    @Override
    public Map<String, String> getAllFlags() {
        if (this.m_allFlags == null) {
            this.m_allFlags = new HashMap<String, String>();
            for (DataObject row : this.m_userSecurityResultSet.getRows()) {
                this.m_allFlags.put((String)row.get("flag"), (String)row.get("value"));
            }
        }
        return this.m_allFlags;
    }

    @Override
    public Map<String, Boolean> getAllFlagsAsBoolean() {
        if (this.m_allFlagsAsBoolean == null) {
            this.m_allFlagsAsBoolean = new HashMap<String, Boolean>();
            for (Map.Entry<String, String> entry : this.getAllFlags().entrySet()) {
                this.m_allFlagsAsBoolean.put(entry.getKey(), StringTools.isTrue(entry.getValue()));
            }
        }
        return this.m_allFlagsAsBoolean;
    }

    @Override
    public Set<String> getAllTrueFlags() {
        if (this.m_allTrueFlags == null) {
            this.m_allTrueFlags = new HashSet<String>();
            for (Map.Entry<String, Boolean> entry : this.getAllFlagsAsBoolean().entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                this.m_allTrueFlags.add(entry.getKey());
            }
        }
        return this.m_allTrueFlags;
    }

    @Override
    public boolean isFlagTrue(String flagName) {
        return this.getAllTrueFlags().contains(flagName.trim());
    }
}

