/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.convenience.usersecurity.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.convenience.usersecurity.CacheId;
import oracle.stellent.ridc.convenience.usersecurity.IAccessResolver;
import oracle.stellent.ridc.convenience.usersecurity.IServiceCallUtils;
import oracle.stellent.ridc.convenience.usersecurity.ITrace;
import oracle.stellent.ridc.convenience.usersecurity.IUserSecurityCache;
import oracle.stellent.ridc.convenience.usersecurity.IUserSecurityFlags;
import oracle.stellent.ridc.convenience.usersecurity.impl.AccessResolverAccounts;
import oracle.stellent.ridc.convenience.usersecurity.impl.AccessResolverAcl;
import oracle.stellent.ridc.convenience.usersecurity.impl.AccessResolverSecurityGroups;
import oracle.stellent.ridc.convenience.usersecurity.impl.CSEnvCache;
import oracle.stellent.ridc.convenience.usersecurity.impl.CachedDataBinder;
import oracle.stellent.ridc.convenience.usersecurity.impl.LRUCache;
import oracle.stellent.ridc.convenience.usersecurity.impl.ServiceCallUtils;
import oracle.stellent.ridc.convenience.usersecurity.impl.Trace;
import oracle.stellent.ridc.convenience.usersecurity.impl.UserSecurityFlags;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;

public class UserSecurityGroupsCache
implements IUserSecurityCache {
    protected ILog m_log = LogFactory.getLog(this.getClass());
    private final String m_cacheBucketName = Long.toHexString(System.currentTimeMillis());
    protected IAccessResolver m_securityGroupsResolver;
    protected List<IAccessResolver> m_accessResolvers;
    protected Map<String, CachedDataBinder> m_userCache;
    protected IdcClient m_idcClient;
    protected long m_timeToLive = 0L;
    protected CSEnvCache m_csEnvCache;
    IServiceCallUtils m_serviceCallUtils = null;
    private ReadWriteLock m_readWriteLock = new ReentrantReadWriteLock();

    public UserSecurityGroupsCache(IdcClient idcClient, int cacheMaxSize, long userTimeToLive, long serverTimeToLive, IdcContext superuser) {
        this.init(idcClient, cacheMaxSize, userTimeToLive);
        this.setServiceCallUtils(new ServiceCallUtils());
        this.m_csEnvCache = new CSEnvCache(idcClient, superuser, serverTimeToLive, this.getServiceCallUtils());
    }

    public UserSecurityGroupsCache(IdcClient idcClient, int cacheMaxSize, long userTimeToLive, long serverTimeToLive, IdcContext superuser, IServiceCallUtils serviceCallUtils) {
        this.init(idcClient, cacheMaxSize, userTimeToLive);
        this.setServiceCallUtils(serviceCallUtils);
        this.m_csEnvCache = new CSEnvCache(idcClient, superuser, serverTimeToLive, this.getServiceCallUtils());
    }

    public UserSecurityGroupsCache(IdcClient idcClient, int cacheMaxSize, long timeToLive) {
        this.init(idcClient, cacheMaxSize, timeToLive);
        this.setServiceCallUtils(new ServiceCallUtils());
        this.m_csEnvCache = new CSEnvCache(idcClient, null, 1800000L, this.getServiceCallUtils());
    }

    public UserSecurityGroupsCache(IdcClient idcClient, int cacheMaxSize, long timeToLive, IServiceCallUtils serviceCallUtils) {
        this.init(idcClient, cacheMaxSize, timeToLive);
        this.setServiceCallUtils(serviceCallUtils);
        this.m_csEnvCache = new CSEnvCache(idcClient, null, 1800000L, this.getServiceCallUtils());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeCache(int maxSize, long timeToLive) {
        try {
            this.m_readWriteLock.writeLock().lock();
            this.m_userCache = Collections.synchronizedMap(new LRUCache(maxSize));
            if (timeToLive > 0L) {
                this.m_timeToLive = timeToLive;
            }
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
    }

    private void init(IdcClient idcClient, int cacheMaxSize, long timeToLive) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("Created cache '%s' for '%s', size: %d, ttl: %d", this.m_cacheBucketName, idcClient != null ? ((IdcClientConfig)idcClient.getConfig()).getConnectionString() : "<none>", cacheMaxSize, timeToLive), ILog.Level.TRACE);
        }
        this.m_securityGroupsResolver = new AccessResolverSecurityGroups();
        this.m_accessResolvers = new ArrayList<IAccessResolver>();
        this.initializeCache(cacheMaxSize, timeToLive);
        this.setIdcClient(idcClient);
    }

    public IServiceCallUtils getServiceCallUtils() {
        return this.m_serviceCallUtils;
    }

    public void setServiceCallUtils(IServiceCallUtils serviceCallUtils) {
        this.m_serviceCallUtils = serviceCallUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAccessResolver(IAccessResolver accessResolver) {
        try {
            this.m_readWriteLock.writeLock().lock();
            this.m_accessResolvers.add(accessResolver);
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        try {
            this.m_readWriteLock.writeLock().lock();
            this.m_userCache.clear();
            for (IAccessResolver handler : this.m_accessResolvers) {
                handler.clearCache();
            }
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("Cleared cache %s", this.m_cacheBucketName), ILog.Level.TRACE);
        }
    }

    @Override
    @Deprecated
    public CacheId getCacheIdForUser(IdcContext userContext) {
        try {
            return this.getCacheIdForUser(userContext, null);
        }
        catch (IdcClientException e) {
            this.m_log.log(e.getMessage(), ILog.Level.ERROR);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheId getCacheIdForUser(IdcContext userContext, ITrace trace) throws IdcClientException {
        CachedDataBinder cachedBinder = this.getServiceCallUtils().getUserPermissions(this.getIdcClient(), userContext, trace);
        DataBinder binder = cachedBinder.getBinder();
        if (binder == null) {
            return null;
        }
        String userId = this.getServiceCallUtils().getUser(binder);
        CacheId id = new CacheId(userId, userContext);
        try {
            this.m_readWriteLock.writeLock().lock();
            this.putPermissions(id, cachedBinder);
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataBinder removeCacheId(CacheId id) {
        DataBinder binder = null;
        try {
            this.m_readWriteLock.writeLock().lock();
            CachedDataBinder permissions = this.removePermissions(id);
            if (permissions != null) {
                binder = permissions.getBinder();
            }
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
        return binder;
    }

    @Override
    @Deprecated
    public int getAccessLevelForDocument(CacheId id, DataObject docInfo) {
        try {
            return this.getAccessLevelForDocument(id, docInfo, null);
        }
        catch (IdcClientException e) {
            this.m_log.log(e.getMessage(), ILog.Level.ERROR);
            return 0;
        }
    }

    @Override
    public int getAccessLevelForDocument(CacheId id, DataObject docInfo, ITrace trace) throws IdcClientException {
        int access;
        if (docInfo == null) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_dataobject_not_allowed());
        }
        DataBinder userBinder = this.getPermissions(id, trace);
        if (trace != null) {
            trace.addTraceStartSection(ITrace.Kind.none, String.format("getAccessLevelForDocument(%s, %s)", id.getUserName(), Trace.getDocTraceId(docInfo)));
        }
        boolean isGroupAdmin = (access = this.m_securityGroupsResolver.resolveAccessLevel(docInfo, userBinder, trace).intValue()) == 15;
        for (IAccessResolver resolver : this.m_accessResolvers) {
            Integer level;
            if (isGroupAdmin && resolver instanceof AccessResolverAcl || (level = resolver.resolveAccessLevel(docInfo, userBinder, trace)) == null) continue;
            access &= level.intValue();
        }
        if (this.isAuthorDelete(id, docInfo, access &= 7, trace)) {
            access |= 4;
        }
        if (trace != null) {
            trace.addTraceEndSection(access);
        }
        return access;
    }

    public boolean isAuthorDelete(CacheId id, DataObject docInfo, int access, ITrace trace) throws IdcClientException {
        boolean hasDelete = false;
        String author = (String)docInfo.get("dDocAuthor");
        if (trace != null) {
            trace.addTraceStartSection(ITrace.Kind.none, String.format("isAuthorDelete(%s, %s, %s)", id.getUserName(), author, Trace.getDocTraceId(docInfo)));
        }
        if (this.m_csEnvCache.isAuthorDeleteEnabled(trace) && id.getUserName().equalsIgnoreCase(author)) {
            hasDelete = true;
        }
        if (trace != null) {
            if (hasDelete) {
                trace.addTrace(ITrace.Kind.none, String.format("isAuthorDelete(%s: %s, %s)", "adding DELETE rights for", author, Trace.getDocTraceId(docInfo)));
            }
            trace.addTraceEndSection();
        }
        return hasDelete;
    }

    @Override
    @Deprecated
    public boolean isAdmin(CacheId id, DataObject docInfo, IUserSecurityCache.AdminType adminType) {
        try {
            return this.isAdmin(id, docInfo, adminType, null);
        }
        catch (IdcClientException e) {
            this.m_log.log(e.getMessage(), ILog.Level.ERROR);
            return false;
        }
    }

    @Override
    public boolean isAdmin(CacheId id, DataObject docInfo, IUserSecurityCache.AdminType adminType, ITrace trace) throws IdcClientException {
        boolean result = false;
        if (adminType == null) {
            return result;
        }
        if (docInfo == null) {
            return result;
        }
        DataBinder userBinder = this.getPermissions(id, trace);
        if (trace != null) {
            trace.addTraceStartSection(ITrace.Kind.none, String.format("isAdmin(%s, %s, %s)", new Object[]{id.getUserName(), Trace.getDocTraceId(docInfo), adminType}));
        }
        block0 : switch (adminType) {
            case GROUP: {
                result = 15 == this.m_securityGroupsResolver.resolveAccessLevel(docInfo, userBinder, trace);
                break;
            }
            case ACCOUNT: {
                for (IAccessResolver resolver : this.m_accessResolvers) {
                    if (!(resolver instanceof AccessResolverAccounts)) continue;
                    Integer access = resolver.resolveAccessLevel(docInfo, userBinder, trace);
                    result = access != null && access == 15;
                    break block0;
                }
                break;
            }
            case ACL: {
                for (IAccessResolver resolver : this.m_accessResolvers) {
                    if (!(resolver instanceof AccessResolverAcl)) continue;
                    Integer access = resolver.resolveAccessLevel(docInfo, userBinder, trace);
                    result = access != null && access == 15;
                    break block0;
                }
                break;
            }
        }
        if (trace != null) {
            trace.addTraceEndSection(result, adminType);
        }
        return result;
    }

    public void setIdcClient(IdcClient idcClient) {
        this.m_idcClient = idcClient;
    }

    public IdcClient getIdcClient() {
        return this.m_idcClient;
    }

    public int getInUseCount() {
        return this.m_userCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStaleEntries() {
        try {
            this.m_readWriteLock.writeLock().lock();
            int startCount = this.m_userCache.size();
            Iterator<Map.Entry<String, CachedDataBinder>> mapIter = this.m_userCache.entrySet().iterator();
            while (mapIter.hasNext()) {
                Map.Entry<String, CachedDataBinder> entry = mapIter.next();
                if (!entry.getValue().hasExpired(this.m_timeToLive)) continue;
                mapIter.remove();
            }
            if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
                int remaining = this.m_userCache.size();
                this.m_log.log(String.format("removed %d stale permissions, %d remaining in cache %s", startCount - remaining, remaining, this.m_cacheBucketName), ILog.Level.TRACE);
            }
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder getPermissions(CacheId id, ITrace trace) throws IdcClientException {
        if (id == null || id.getUserName() == null || id.getUserName().length() == 0) {
            throw new IdcClientException(RIDCMessages.convenience_usersecurity_null_cacheid_not_allowed());
        }
        CachedDataBinder cachedPermissions = null;
        Lock lock = null;
        try {
            lock = this.m_readWriteLock.readLock();
            lock.lock();
            cachedPermissions = this.m_userCache.get(id.getUserName());
            if (cachedPermissions == null || cachedPermissions.hasExpired(this.m_timeToLive)) {
                lock.unlock();
                lock = this.m_readWriteLock.writeLock();
                lock.lock();
                cachedPermissions = this.m_userCache.get(id.getUserName());
                if (cachedPermissions == null || cachedPermissions.hasExpired(this.m_timeToLive)) {
                    cachedPermissions = this.getServiceCallUtils().getUserPermissions(this.getIdcClient(), id.getUserContext(), trace);
                    if (cachedPermissions.getBinder() == null) {
                        this.removePermissions(id);
                    } else {
                        this.putPermissions(id, cachedPermissions);
                    }
                }
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("Returning permissions for %s from cache %s (inserted at %d)", id.getUserName(), this.m_cacheBucketName, cachedPermissions.getBinderFetchTime()), ILog.Level.TRACE);
        }
        return cachedPermissions.getBinder();
    }

    protected void putPermissions(CacheId id, CachedDataBinder permissions) {
        this.m_userCache.put(id.getUserName(), permissions);
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("Added permissions for %s to cache %s at %d", id.getUserName(), this.m_cacheBucketName, permissions.getBinderFetchTime()), ILog.Level.TRACE);
        }
    }

    protected CachedDataBinder removePermissions(CacheId id) {
        CachedDataBinder binder = this.m_userCache.remove(id.getUserName());
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("Removed permissions inserted at %d for %s from cache %s", binder.getBinderFetchTime(), id.getUserName(), this.m_cacheBucketName), ILog.Level.TRACE);
        }
        return binder;
    }

    @Override
    public IUserSecurityFlags getUserSecurityFlags(CacheId id, ITrace trace) throws IdcClientException {
        DataResultSet userSecurityFlags = this.getPermissions(id, trace).getResultSet("UserSecurityFlags");
        if (userSecurityFlags == null) {
            throw new IdcClientException(RIDCMessages.model_resultset_not_found("UserSecurityFlags"));
        }
        return new UserSecurityFlags(userSecurityFlags);
    }
}

