/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.filter.IIdcFilter;
import oracle.stellent.ridc.filter.IdcFilterException;
import oracle.stellent.ridc.filter.IdcFilterType;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class IdcFilterManager {
    private SortedMap<Integer, IIdcFilter> m_filters = new TreeMap<Integer, IIdcFilter>();
    private final ILog m_log = LogFactory.getLog(this.getClass());

    public void executeFilters(IdcFilterType ftype, Object ... objects) throws IdcClientException {
        for (Map.Entry<Integer, IIdcFilter> entry : this.m_filters.entrySet()) {
            IIdcFilter filter = entry.getValue();
            String fname = filter.getClass().getName();
            int fslot = entry.getKey();
            this.m_log.log(String.format("Calling IdcFilter %s in slot %s", fname, fslot), ILog.Level.DEBUG);
            filter.doFilter(ftype, objects);
        }
    }

    public synchronized int registerFilter(int slot, IIdcFilter filter) throws IdcFilterException {
        if (filter == null) {
            throw new IdcFilterException(RIDCMessages.filter_manager_null_filter_class());
        }
        int i = slot;
        while (this.m_filters.containsKey(i)) {
            if (i == Integer.MAX_VALUE) {
                throw new IdcFilterException(RIDCMessages.filter_manager_no_slots_left(filter.getClass().getCanonicalName(), slot, i));
            }
            ++i;
        }
        this.m_filters.put(i, filter);
        return i;
    }

    public synchronized IIdcFilter deRegisterFilter(int slot, IIdcFilter filter) throws IdcFilterException {
        if (filter == null) {
            throw new IdcFilterException(RIDCMessages.filter_manager_missing_instance());
        }
        if (filter != this.getFilter(slot)) {
            throw new IdcFilterException(RIDCMessages.filter_manager_instance_does_not_match(slot));
        }
        return (IIdcFilter)this.m_filters.remove(slot);
    }

    public IIdcFilter getFilter(int slot) {
        return (IIdcFilter)this.m_filters.get(slot);
    }

    public List<Integer> getUsedSlots() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(this.m_filters.keySet());
        return result;
    }
}

