/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.filter.adapters;

import java.util.Map;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.auth.CredentialsReference;
import oracle.stellent.ridc.auth.CredentialsType;
import oracle.stellent.ridc.convenience.adf.connection.AdfConnectionFacade;
import oracle.stellent.ridc.convenience.adf.mbeans.IdcConnectionType;
import oracle.stellent.ridc.filter.IIdcFilter;
import oracle.stellent.ridc.filter.IdcFilterType;
import oracle.stellent.ridc.model.DataBinder;

public abstract class IdcFilterAdapter
implements IIdcFilter {
    @Override
    public void doFilter(IdcFilterType ftype, Object ... objects) throws IdcClientException {
        IdcClient client = null;
        IdcContext context = null;
        DataBinder binder = null;
        Map requestContext = null;
        String text = null;
        IdcConnectionType connectionType = null;
        Credentials credentials = null;
        CredentialsReference credentialsReference = null;
        CredentialsType credentialsType = null;
        AdfConnectionFacade.ResultTestConnection resultTestConnection = null;
        for (Object obj : objects) {
            if (obj instanceof IdcClient) {
                client = (IdcClient)obj;
                continue;
            }
            if (obj instanceof IdcContext) {
                context = (IdcContext)obj;
                continue;
            }
            if (obj instanceof DataBinder) {
                binder = (DataBinder)obj;
                continue;
            }
            if (obj instanceof Map) {
                requestContext = (Map)obj;
                continue;
            }
            if (obj instanceof String) {
                text = (String)obj;
                continue;
            }
            if (obj instanceof IdcConnectionType) {
                connectionType = (IdcConnectionType)((Object)obj);
                continue;
            }
            if (obj instanceof Credentials) {
                credentials = (Credentials)obj;
                continue;
            }
            if (obj instanceof CredentialsReference) {
                credentialsReference = (CredentialsReference)obj;
                continue;
            }
            if (obj instanceof CredentialsType) {
                credentialsType = (CredentialsType)((Object)obj);
                continue;
            }
            if (!(obj instanceof AdfConnectionFacade.ResultTestConnection)) continue;
            resultTestConnection = (AdfConnectionFacade.ResultTestConnection)obj;
        }
        switch (ftype) {
            case beforeServiceRequest: {
                this.beforeServiceRequest(client, context, binder);
                break;
            }
            case beforeJaxwsAuthenicateUser: {
                this.beforeJaxwsAuthenticateUser(context, binder, requestContext);
                break;
            }
            case beforeJaxwsServiceRequest: {
                this.beforeJaxwsServiceRequest(context, binder, requestContext);
                break;
            }
            case beforeJaxwsLogoutUser: {
                this.beforeJaxwsLogoutUser(context, binder, requestContext);
                break;
            }
            case beforeAdfConnectionGetUserCredential: {
                this.beforeAdfConnectionGetUserCredential(connectionType, credentialsReference);
                break;
            }
            case beforeAdfConnectionTestConnection: {
                this.beforeAdfConnectionTestConnection(client, credentials, credentialsType, resultTestConnection);
                break;
            }
            case beforeLogout: {
                this.beforeLogout(client, context, binder);
            }
        }
    }

    public void beforeServiceRequest(IdcClient client, IdcContext context, DataBinder binder) throws IdcClientException {
    }

    public void beforeJaxwsAuthenticateUser(IdcContext context, DataBinder binder, Map<String, Object> requestContext) throws IdcClientException {
    }

    public void beforeJaxwsServiceRequest(IdcContext context, DataBinder binder, Map<String, Object> requestContext) throws IdcClientException {
    }

    public void beforeJaxwsLogoutUser(IdcContext context, DataBinder binder, Map<String, Object> requestContext) throws IdcClientException {
    }

    public void beforeAdfConnectionGetUserCredential(IdcConnectionType connectionType, CredentialsReference credentialsReference) {
    }

    public void beforeAdfConnectionTestConnection(IdcClient idcClient, Credentials credentials, CredentialsType credentialsType, AdfConnectionFacade.ResultTestConnection result) {
    }

    public void beforeLogout(IdcClient client, IdcContext context, DataBinder binder) throws IdcClientException {
    }
}

