/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.filter.dms;

import oracle.dms.context.ExecutionContext;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.filter.IIdcFilter;
import oracle.stellent.ridc.filter.IdcFilterType;
import oracle.stellent.ridc.model.DataBinder;

public final class DmsFilter
implements IIdcFilter {
    private static Boolean s_dmsEcidFound = null;
    private final ILog m_log = LogFactory.getLog(DmsFilter.class);

    public static boolean useECID() {
        if (s_dmsEcidFound == null) {
            try {
                Class<?> c = Class.forName("oracle.dms.context.ExecutionContext");
                s_dmsEcidFound = c != null;
            }
            catch (Throwable t) {
                s_dmsEcidFound = false;
            }
        }
        return s_dmsEcidFound;
    }

    private void passAlongECID(DataBinder binder) {
        ExecutionContext ctx = ExecutionContext.get();
        binder.putLocal("ECID-Context", ctx.wrap());
        if (this.m_log.isLogEnabled(ILog.Level.DEBUG)) {
            this.m_log.log(String.format("Added %s=%s to binder", "ECID-Context", ctx.wrap()), ILog.Level.DEBUG);
        }
    }

    @Override
    public void doFilter(IdcFilterType ftype, Object ... objects) {
        if (DmsFilter.useECID() && ftype == IdcFilterType.beforeServiceRequest) {
            for (Object obj : objects) {
                if (!(obj instanceof DataBinder)) continue;
                this.passAlongECID((DataBinder)obj);
            }
        }
    }
}

