/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.i18n.utils;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import oracle.stellent.ridc.i18n.locale.LocaleMessage;
import oracle.stellent.ridc.i18n.utils.MnemonicKeyValidator;
import oracle.stellent.ridc.i18n.utils.SimpleMnemonicKeyValidator;

public class MnemonicUtil {
    public static final char MNEMONIC_INDICATOR = '&';
    public static final char OPENING_PARENTHESIS = '(';
    public static final char CLOSING_PARENTHESIS = ')';
    private static MnemonicKeyValidator mnemonicKeyValidator = new SimpleMnemonicKeyValidator();

    public static int getMnemonicCharacter(String labelAndMnemonic) throws NullPointerException {
        int mnemonicCharacter = 0;
        int indexOfMnemonicIndicator = labelAndMnemonic.indexOf(38);
        if (indexOfMnemonicIndicator > -1 && indexOfMnemonicIndicator + 1 < labelAndMnemonic.length()) {
            mnemonicCharacter = labelAndMnemonic.substring(indexOfMnemonicIndicator + 1, indexOfMnemonicIndicator + 2).toUpperCase().charAt(0);
        }
        return mnemonicCharacter;
    }

    public static int getMnemonicIndex(String labelAndMnemonic) throws NullPointerException {
        int indexOfMnemonicIndicator = labelAndMnemonic.indexOf(38);
        return indexOfMnemonicIndicator != -1 ? indexOfMnemonicIndicator : 0;
    }

    public static String extractLabelTextWithMnemonic(String labelAndMnemonic) throws NullPointerException {
        String label;
        if (labelAndMnemonic.length() == 0) {
            label = "";
        } else {
            int indexOfMnemonicIndicator = labelAndMnemonic.indexOf(38);
            if (indexOfMnemonicIndicator < 0) {
                label = labelAndMnemonic;
            } else {
                StringBuffer sb = new StringBuffer(labelAndMnemonic);
                label = sb.deleteCharAt(indexOfMnemonicIndicator).toString();
            }
        }
        return label;
    }

    public static String addMnemonicToLabel(String label, char mnemonic) throws NullPointerException {
        String labelAndMnemonic = !MnemonicUtil.isValidMnemonicKey(mnemonic) ? label : (label.toUpperCase().indexOf(Character.toUpperCase(mnemonic)) >= 0 ? label : label + "(" + mnemonic + ")");
        return labelAndMnemonic;
    }

    public static String extractLabelTextWithoutMnemonic(String labelAndMnemonic) throws NullPointerException {
        String label;
        if (labelAndMnemonic.length() == 0) {
            label = "";
        } else {
            int indexOfMnemonicIndicator = labelAndMnemonic.indexOf(38);
            if (indexOfMnemonicIndicator < 0) {
                int indexOfClosingParenthesis;
                int indexOfOpeningParenthesis = labelAndMnemonic.lastIndexOf(40);
                if (indexOfOpeningParenthesis + 2 == (indexOfClosingParenthesis = labelAndMnemonic.lastIndexOf(41))) {
                    StringBuffer sb = new StringBuffer(labelAndMnemonic);
                    label = sb.delete(indexOfOpeningParenthesis, indexOfClosingParenthesis + 1).toString();
                } else {
                    label = labelAndMnemonic;
                }
            } else {
                int indexOfOpeningParenthesis = labelAndMnemonic.lastIndexOf(40, indexOfMnemonicIndicator);
                int indexOfClosingParenthesis = labelAndMnemonic.indexOf(41, indexOfMnemonicIndicator);
                StringBuffer sb = new StringBuffer(labelAndMnemonic);
                if (indexOfOpeningParenthesis == indexOfMnemonicIndicator - 1 && indexOfClosingParenthesis == indexOfMnemonicIndicator + 2) {
                    sb.delete(indexOfOpeningParenthesis, indexOfClosingParenthesis + 1);
                } else {
                    sb.deleteCharAt(indexOfMnemonicIndicator);
                }
                label = sb.toString();
            }
        }
        return label;
    }

    public static void setTextAndMnemonic(AbstractButton button, LocaleMessage buttonText) {
        button.setText(buttonText.getText());
        button.setMnemonic(buttonText.getMnemonicCharacter());
    }

    public static void setLabelAndTextFor(JLabel label, Component labelFor, LocaleMessage labelText) {
        label.setText(labelText.getText());
        label.setDisplayedMnemonic(labelText.getMnemonicCharacter());
        label.setLabelFor(labelFor);
    }

    public static boolean isValidMnemonicKey(int key) {
        MnemonicKeyValidator validator = MnemonicUtil.getMnemonicKeyValidator();
        if (validator != null) {
            return validator.isValidMnemonicKey(key);
        }
        return true;
    }

    public static void setMnemonicKeyValidator(MnemonicKeyValidator mnemonicKeyValidator) {
        MnemonicUtil.mnemonicKeyValidator = mnemonicKeyValidator;
    }

    public static MnemonicKeyValidator getMnemonicKeyValidator() {
        return mnemonicKeyValidator;
    }
}

