/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TransferFile {
    private InputStream m_inputStream = null;
    private long m_contentLength = 0L;
    private String m_contentType = null;
    private String m_fileName = null;
    private TransferListener m_transferListener = null;

    public TransferFile() {
    }

    public TransferFile(InputStream inputStream, String fileName, long contentLength, String contentType) {
        this.m_inputStream = inputStream;
        this.m_fileName = fileName;
        this.m_contentLength = contentLength;
        this.m_contentType = contentType;
    }

    public TransferFile(InputStream inputStream, String fileName, long contentLength) {
        this.m_inputStream = inputStream;
        this.m_fileName = fileName;
        this.m_contentLength = contentLength;
    }

    public TransferFile(File file) throws IOException {
        this(file, null);
    }

    public TransferFile(File file, String contentType) throws IOException {
        this.m_inputStream = new FileInputStream(file);
        this.m_fileName = file.getName();
        this.m_contentLength = file.length();
        this.m_contentType = contentType;
    }

    public InputStream getInputStream() throws IOException {
        return this.m_inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.m_inputStream = inputStream;
    }

    public String getContentType() {
        if (this.m_contentType == null) {
            this.m_contentType = "application/octet-stream";
        }
        return this.m_contentType;
    }

    public void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    public long getContentLength() {
        return this.m_contentLength;
    }

    public void setContentLength(long contentLength) {
        this.m_contentLength = contentLength;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String toString() {
        return "{" + this.getFileName() + " [" + this.getContentType() + "," + this.getContentLength() + "]}";
    }

    public void notifyBufferWrite(long bytes) {
        if (this.getTransferListener() != null) {
            this.getTransferListener().notifyBufferWrite(bytes);
        }
    }

    public TransferListener getTransferListener() {
        return this.m_transferListener;
    }

    public void setTransferListener(TransferListener listener) {
        this.m_transferListener = listener;
    }

    public class TransferProgress
    implements TransferListener {
        private final Object m_synchronizer = new Object();
        private final long m_contentLength;
        private long m_totalBytesTransferred = 0L;

        public TransferProgress(long contentLength) {
            this.m_contentLength = contentLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyBufferWrite(long bytes) {
            Object object = this.m_synchronizer;
            synchronized (object) {
                this.m_totalBytesTransferred += bytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getBytesTransferred() {
            long bytesTransferred;
            Object object = this.m_synchronizer;
            synchronized (object) {
                bytesTransferred = this.m_totalBytesTransferred;
            }
            return bytesTransferred;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTransferPercentage() {
            long bytesTransferred;
            Object object = this.m_synchronizer;
            synchronized (object) {
                bytesTransferred = this.m_totalBytesTransferred;
            }
            return this.m_contentLength > 0L ? (int)(100L * bytesTransferred / this.m_contentLength) : -1;
        }
    }

    public static interface TransferListener {
        public void notifyBufferWrite(long var1);
    }
}

