/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.model.impl;

import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.model.impl.DataObjectEncodingUtils;
import oracle.stellent.ridc.model.impl.DataObjectImpl;

public class DataBinderImpl
implements DataBinder {
    private DataObject m_localData = null;
    private Map<String, String> m_fieldTypes = null;
    private Map<String, DataResultSet> m_resultSets = null;
    private Map<String, List<String>> m_optionLists = null;
    private Map<String, TransferFile> m_files = null;

    public Map<String, List<String>> getOptionLists() {
        if (this.m_optionLists == null) {
            this.m_optionLists = new HashMap<String, List<String>>();
        }
        return this.m_optionLists;
    }

    public Map<String, TransferFile> getFiles() {
        if (this.m_files == null) {
            this.m_files = new HashMap<String, TransferFile>();
        }
        return this.m_files;
    }

    public void synchronizeData(DataFactory.Direction in) {
        switch (in) {
            case IN: {
                this.m_fieldTypes = this.loadFieldTypes();
                break;
            }
            case OUT: {
                this.serializeFieldTypes();
            }
        }
    }

    @Override
    public DataObject getLocalData() {
        if (this.m_localData == null) {
            this.m_localData = new DataObjectImpl();
            DataObjectEncodingUtils.addLocaleInfo(this);
        }
        return this.m_localData;
    }

    @Override
    public String getFieldType(String name) {
        if (this.m_fieldTypes != null) {
            return this.m_fieldTypes.get(name);
        }
        return null;
    }

    @Override
    public void setFieldType(String name, String type) {
        if (this.m_fieldTypes != null) {
            this.m_fieldTypes.put(name, type);
        }
    }

    @Override
    public Collection<String> getFieldTypeNames() {
        if (this.m_fieldTypes == null) {
            return Collections.emptySet();
        }
        return this.m_fieldTypes.keySet();
    }

    @Override
    public void removeFieldType(String name) {
        if (this.m_fieldTypes != null) {
            this.m_fieldTypes.remove(name);
        }
    }

    @Override
    public String getLocal(String name) {
        return (String)this.getLocalData().get(name);
    }

    @Override
    public void putLocal(String name, String value) {
        this.getLocalData().put(name, value);
    }

    @Override
    public DataResultSet getResultSet(String name) {
        if (this.m_resultSets != null) {
            return this.m_resultSets.get(name);
        }
        return null;
    }

    @Override
    public Map<String, DataResultSet> getResultSets() {
        if (this.m_resultSets == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_resultSets);
    }

    @Override
    public void removeResultSet(String name) {
        if (this.m_resultSets != null) {
            this.m_resultSets.remove(name);
        }
    }

    @Override
    public Collection<String> getResultSetNames() {
        if (this.m_resultSets != null) {
            return this.m_resultSets.keySet();
        }
        return Collections.emptyList();
    }

    @Override
    public void addResultSet(String name, DataResultSet resultSet) {
        if (this.m_resultSets == null) {
            this.m_resultSets = new HashMap<String, DataResultSet>();
        }
        this.m_resultSets.put(name, resultSet);
    }

    @Override
    public List<String> getOptionList(String name) {
        if (this.m_optionLists != null) {
            return this.m_optionLists.get(name);
        }
        return null;
    }

    @Override
    public Collection<String> getOptionListNames() {
        if (this.m_optionLists != null) {
            return this.m_optionLists.keySet();
        }
        return Collections.emptyList();
    }

    @Override
    public void addOptionList(String name, List<String> values) {
        this.getOptionLists().put(name, values);
    }

    @Override
    public void removeOptionList(String name) {
        if (this.m_optionLists != null) {
            this.m_optionLists.remove(name);
        }
    }

    @Override
    public Collection<String> getFileNames() {
        if (this.m_files != null) {
            return this.m_files.keySet();
        }
        return Collections.emptyList();
    }

    @Override
    public TransferFile getFile(String name) {
        if (this.m_files != null) {
            return this.m_files.get(name);
        }
        return null;
    }

    @Override
    public void addFile(String name, File file) throws IOException {
        this.getFiles().put(name, new TransferFile(file));
    }

    @Override
    public void addFile(String name, TransferFile file) {
        this.getFiles().put(name, file);
    }

    @Override
    public void removeFile(String name) {
        if (this.m_files != null) {
            this.m_files.remove(name);
        }
    }

    @Override
    public boolean containsFiles() {
        return this.m_files != null && !this.m_files.isEmpty();
    }

    @Override
    public void merge(DataBinder source) {
        String fieldTypes = this.getLocal("blFieldTypes");
        String otherFieldTypes = source.getLocal("blFieldTypes");
        if (otherFieldTypes != null) {
            if (fieldTypes == null) {
                fieldTypes = "";
            }
            fieldTypes = fieldTypes + "," + otherFieldTypes;
        }
        this.getLocalData().putAll(source.getLocalData());
        if (!StringTools.isEmpty(fieldTypes)) {
            this.putLocal("blFieldTypes", fieldTypes);
        }
        this.synchronizeData(DataFactory.Direction.IN);
        for (String name : source.getResultSetNames()) {
            DataResultSet rs = source.getResultSet(name);
            this.addResultSet(name, rs);
        }
        for (String name : source.getOptionListNames()) {
            List<String> optionList = source.getOptionList(name);
            this.addOptionList(name, optionList);
        }
    }

    protected Map<String, String> loadFieldTypes() {
        HashMap<String, String> fieldMappings = new HashMap<String, String>();
        String fieldTypes = this.getLocal("blFieldTypes");
        if (!StringTools.isEmpty(fieldTypes)) {
            String[] mappings;
            for (String mapping : mappings = fieldTypes.split(",")) {
                String[] nameValue = mapping.split(" ");
                fieldMappings.put(nameValue[0], nameValue[1]);
            }
        }
        return fieldMappings;
    }

    protected void serializeFieldTypes() {
        if (this.m_fieldTypes != null) {
            StringBuffer sb = new StringBuffer();
            Iterator<String> it = this.m_fieldTypes.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                String value = this.m_fieldTypes.get(name);
                sb.append(name).append(" ").append(value);
                if (!it.hasNext()) continue;
                sb.append(",");
            }
        }
    }

    public String toString() {
        TreeSet<String> sortedNames;
        TreeMap<String, String> sortedLocalData = new TreeMap<String, String>(this.getLocalData());
        String result = "";
        String idcService = null;
        for (Map.Entry item : sortedLocalData.entrySet()) {
            if (idcService == null && "IdcService".equals(item.getKey())) {
                idcService = String.format("  IdcService: %s\n", item.getValue());
                continue;
            }
            result = result + String.format("  %s: %s\n", item.getKey(), item.getValue());
        }
        if (idcService != null) {
            result = idcService + result;
        }
        result.trim();
        if (!this.getResultSetNames().isEmpty()) {
            sortedNames = new TreeSet<String>(this.getResultSetNames());
            String resultsets = "";
            for (String name : sortedNames) {
                resultsets = resultsets + String.format(" '%s'", name);
            }
            result = result + String.format("    embedded ResultSets: %s", resultsets);
        }
        if (!this.getFileNames().isEmpty()) {
            sortedNames = new TreeSet<String>(this.getFileNames());
            String filenames = "";
            for (String name : sortedNames) {
                filenames = filenames + String.format(" '%s'", name);
            }
            result = result + String.format("    embedded Files: %s", filenames);
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(RIDCMessages.serialize_not_serializable(this.getClass().getName()).toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(RIDCMessages.serialize_not_serializable(this.getClass().getName()).toString());
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new NotSerializableException(RIDCMessages.serialize_not_serializable(this.getClass().getName()).toString());
    }
}

