/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.model.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import oracle.stellent.ridc.common.util.ISO8601;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataObject;

public abstract class DataObjectEncodingUtils {
    public static final String ODBC_PREFIX = "{ts '";
    public static final String ODBC_POSTFIX = "'}";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_STRING = "iso8601";

    public static void addLocaleInfo(DataBinder dataBinder) {
        dataBinder.putLocal("UserDateFormat", DATE_STRING);
        dataBinder.putLocal("UserTimeZone", "UTC");
    }

    public static boolean getBoolean(DataObject dataObject, String name, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        String value = (String)dataObject.get(name);
        if (value != null && value.trim().length() > 0) {
            booleanValue = "1".equals(value) || "true".equalsIgnoreCase(value);
        }
        return booleanValue;
    }

    public static void setBoolean(DataObject dataObject, String name, boolean value) {
        dataObject.put(name, String.valueOf(value));
    }

    public static int getInteger(DataObject dataObject, String name, int defaultValue) {
        String value = (String)dataObject.get(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLong(DataObject dataObject, String name, long defaultValue) {
        String value = (String)dataObject.get(name);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void setDate(DataObject dataObject, String name, Date date) {
        dataObject.put(name, DataObjectEncodingUtils.encodeDate(date));
    }

    public static Calendar getCalendar(DataObject dataObject, String name) {
        String value = (String)dataObject.get(name);
        if (!StringTools.isEmpty(value)) {
            try {
                return DataObjectEncodingUtils.decodeDate(value);
            }
            catch (ParseException exp) {
                throw new RuntimeException(exp);
            }
        }
        return null;
    }

    public static String encodeDate(Date date) {
        StringBuffer dateString = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        dateString.append(dateFormat.format(date));
        return dateString.toString();
    }

    public static Calendar decodeDate(String dateString) throws ParseException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        if (dateString.startsWith(ODBC_PREFIX)) {
            dateString = dateString.substring(ODBC_PREFIX.length(), dateString.length() - ODBC_POSTFIX.length());
        }
        return ISO8601.parseISO8601(dateString, tz);
    }
}

