/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.impl.DataResultSetRow;

public class DataResultSetImpl
implements DataResultSet {
    private List<DataResultSet.Field> m_fields = new ArrayList<DataResultSet.Field>();
    private Map<String, Integer> m_fieldIndexes = new HashMap<String, Integer>();
    private List<List<String>> m_rows = null;

    @Override
    public boolean hasField(String name) {
        return this.getFieldIndex(name) != -1;
    }

    @Override
    public DataResultSet.Field getField(String name) {
        return this.getField(this.getFieldIndex(name));
    }

    @Override
    public DataResultSet.Field getField(int index) {
        return this.m_fields.get(index);
    }

    @Override
    public List<DataResultSet.Field> getFields() {
        if (this.m_fields != null) {
            return Collections.unmodifiableList(this.m_fields);
        }
        return Collections.emptyList();
    }

    @Override
    public void setFields(List<DataResultSet.Field> fields) {
        if (this.m_rows != null) {
            this.m_rows.clear();
        }
        this.m_fields.clear();
        this.m_fields.addAll(fields);
        this.m_fieldIndexes.clear();
        for (int i = 0; i < this.m_fields.size(); ++i) {
            DataResultSet.Field field = this.m_fields.get(i);
            this.m_fieldIndexes.put(field.getName(), i);
        }
    }

    @Override
    public void addField(DataResultSet.Field field, String defaultValue) {
        if (this.hasField(field.getName())) {
            throw new IllegalArgumentException(RIDCMessages.model_resultset_cannot_add_field(field.getName()).toString());
        }
        int index = this.m_fields.size();
        this.m_fields.add(field);
        this.m_fieldIndexes.put(field.getName(), index);
        if (this.m_rows != null) {
            for (List<String> row : this.m_rows) {
                row.add(defaultValue);
            }
        }
    }

    @Override
    public void addRow(List<String> items) {
        this.insertRow(items, -1);
    }

    @Override
    public void insertRow(List<String> items, int index) {
        if (items.size() != this.m_fields.size()) {
            throw new IllegalArgumentException(RIDCMessages.model_resultset_cannot_add_row_col_mismatch().toString());
        }
        if (this.m_rows == null) {
            this.m_rows = new ArrayList<List<String>>();
        }
        ArrayList<String> newItems = new ArrayList<String>(items);
        if (index >= 0) {
            this.m_rows.add(index, newItems);
        } else {
            this.m_rows.add(newItems);
        }
    }

    @Override
    public void addRow(DataObject row) {
        this.insertRow(row, -1);
    }

    @Override
    public void insertRow(DataObject row, int index) {
        if (this.m_fields.isEmpty()) {
            throw new IllegalArgumentException(RIDCMessages.model_resultset_cannot_add_row_no_fields().toString());
        }
        ArrayList<String> values = new ArrayList<String>(this.m_fields.size());
        for (int i = 0; i < this.m_fields.size(); ++i) {
            values.add("");
        }
        for (String name : row.keySet()) {
            int fieldIndex = this.getFieldIndex(name);
            if (fieldIndex == -1 || !row.containsKey(name)) continue;
            values.set(fieldIndex, (String)row.get(name));
        }
        this.insertRow(values, index);
    }

    @Override
    public void removeRow(int row) {
        if (this.m_rows != null && row >= 0 && row < this.m_rows.size()) {
            this.m_rows.remove(row);
        }
    }

    @Override
    public void removeField(String name) {
        if (!this.hasField(name)) {
            return;
        }
        int index = this.m_fieldIndexes.remove(name);
        this.m_fields.remove(index);
        if (this.m_rows != null) {
            for (List<String> row : this.m_rows) {
                row.remove(index);
            }
        }
    }

    @Override
    public List<DataObject> getRows() {
        if (this.m_rows == null) {
            return Collections.emptyList();
        }
        ArrayList<DataObject> rows = new ArrayList<DataObject>(this.m_rows.size());
        for (List<String> row : this.m_rows) {
            rows.add(new DataResultSetRow(this, row));
        }
        return rows;
    }

    protected int getFieldIndex(String name) {
        Integer index;
        if (this.m_fieldIndexes != null && (index = this.m_fieldIndexes.get(name)) != null) {
            return index;
        }
        return -1;
    }
}

